/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;

public class ObjectsSelectionDialog<T>
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<T> listModel = new DefaultListModel();
    private final List<T> selectedObjects = new ArrayList<T>();
    private boolean accepted;
    private final ListSelectionListener objectSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectsSelectionDialog.this.setSelectedObjects();
                ObjectsSelectionDialog.this.setOkButtonEnabled();
            }
        }
    };
    private final MouseListener doubleClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventUtil.isDoubleClick(e)) {
                ObjectsSelectionDialog.this.setSelectedObjects();
                ObjectsSelectionDialog.this.acceptInput();
            }
        }
    };
    private JButton buttonOk;
    private JList<T> list;
    private JScrollPane scrollPane;

    public ObjectsSelectionDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.list.addListSelectionListener(this.objectSelectionListener);
        this.list.addMouseListener(this.doubleClickListener);
        this.setOkButtonEnabled();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setObjects(Collection<? extends T> objects) {
        if (objects == null) {
            throw new NullPointerException("objects == null");
        }
        this.listModel.clear();
        for (T object : objects) {
            this.listModel.addElement(object);
        }
    }

    public List<T> getSelectedObjects() {
        return Collections.unmodifiableList(this.selectedObjects);
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    private void setOkButtonEnabled() {
        boolean objectSelected = this.list.getSelectedIndex() >= 0;
        this.buttonOk.setEnabled(objectSelected);
    }

    private void setSelectedObjects() {
        this.selectedObjects.clear();
        this.selectedObjects.addAll(this.list.getSelectedValuesList());
    }

    private void acceptInput() {
        if (!this.selectedObjects.isEmpty()) {
            this.accepted = true;
            this.dispose();
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.list.setModel(this.listModel);
        this.scrollPane.setViewportView(this.list);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.buttonOk.setText(bundle.getString("ObjectsSelectionDialog.buttonOk.text"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsSelectionDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOk)).addComponent(this.scrollPane, -1, 245, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 203, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.acceptInput();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectsSelectionDialog dialog = new ObjectsSelectionDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

