/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.lib.awt.EventQueueUtil;

public final class MessageLabel {
    private final JLabel label;
    private long removeTextTimeMillis;
    private Thread currentHideTextThread;
    private final Object monitor = new Object();

    public MessageLabel(JLabel label) {
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessage(final String message, final MessageType type, long milliseconds) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("Negative milliseconds: " + milliseconds);
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                MessageLabel.this.label.setForeground(MessageLabel.this.getForegroundColorOfMessageType(type));
                MessageLabel.this.label.setText(message);
            }
        });
        Object object = this.monitor;
        synchronized (object) {
            if (this.currentHideTextThread != null) {
                return;
            }
            this.removeTextTimeMillis = System.currentTimeMillis() + milliseconds;
            this.currentHideTextThread = new HideTextThread();
            this.currentHideTextThread.start();
        }
    }

    private Color getForegroundColorOfMessageType(MessageType type) {
        return type.isError() ? Color.RED : Color.BLACK;
    }

    private class HideTextThread
    extends Thread {
        private HideTextThread() {
            super("JPhotoTagger: Hiding message label text");
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimeMillis = System.currentTimeMillis();
            long sleepTime = 0L;
            Object object = MessageLabel.this.monitor;
            synchronized (object) {
                sleepTime = MessageLabel.this.removeTextTimeMillis - currentTimeMillis;
            }
            while (sleepTime > 0L && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, t);
                }
                currentTimeMillis = System.currentTimeMillis();
                object = MessageLabel.this.monitor;
                synchronized (object) {
                    sleepTime = MessageLabel.this.removeTextTimeMillis - currentTimeMillis;
                }
            }
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MessageLabel.this.label.setText("");
                    Object object = MessageLabel.this.monitor;
                    synchronized (object) {
                        MessageLabel.this.currentHideTextThread = null;
                    }
                }
            });
        }
    }
}

