/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jphototagger.lib.swing.InputDialog;
import org.jphototagger.lib.swing.LongMessageDialog;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ExceptionUtil;

public final class MessageDisplayer {
    private static final Map<Integer, String> TITLE_OF_MESSAGE_TYPE = new HashMap<Integer, String>(4);

    private MessageDisplayer() {
    }

    public static String input(String message, String input) {
        InputDialog inputDialog = new InputDialog();
        inputDialog.setInfo(message == null ? "" : message);
        inputDialog.setInput(input == null ? "" : input);
        inputDialog.setVisible(true);
        boolean accepted = inputDialog.isAccepted();
        return accepted ? inputDialog.getInput() : null;
    }

    public static void error(Component parentComponent, String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        MessageDisplayer.message(parentComponent, message, 0);
    }

    public static void warning(Component parentComponent, String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        MessageDisplayer.message(parentComponent, message, 2);
    }

    public static void information(Component parentComponent, String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        MessageDisplayer.message(parentComponent, message, 1);
    }

    public static void thrown(String message, Throwable throwable) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable == null");
        }
        LongMessageDialog dlg = new LongMessageDialog(ComponentUtil.findFrameWithIcon(), true);
        dlg.setTitle(Bundle.getString(MessageDisplayer.class, "MessageDisplayer.Title.Thrown", new Object[0]));
        dlg.setErrorIcon();
        dlg.setShortMessage(message);
        String longMessage = throwable.getLocalizedMessage() + "\n" + ExceptionUtil.getStackTraceAsString(throwable);
        dlg.setLongMessage(longMessage);
        dlg.setVisible(true);
    }

    public static ConfirmAction confirmYesNoCancel(Component parentComponent, String message) {
        int optionType;
        String title;
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        Component parent = MessageDisplayer.getNotNullParent(parentComponent);
        int option = JOptionPane.showConfirmDialog(parent, message, title = MessageDisplayer.getTitleOfMessageType(3), optionType = 1);
        return option == 0 ? ConfirmAction.YES : (option == 1 ? ConfirmAction.NO : ConfirmAction.CANCEL);
    }

    public static boolean confirmYesNo(Component parentComponent, String message) {
        int optionType;
        String title;
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        Component parent = MessageDisplayer.getNotNullParent(parentComponent);
        return JOptionPane.showConfirmDialog(parent, message, title = MessageDisplayer.getTitleOfMessageType(3), optionType = 0) == 0;
    }

    private static void message(Component parentComponent, String message, int messageType) {
        Component parent = MessageDisplayer.getNotNullParent(parentComponent);
        String title = MessageDisplayer.getTitleOfMessageType(messageType);
        JOptionPane.showMessageDialog(parent, message, title, messageType);
    }

    private static Component getNotNullParent(Component parentComponent) {
        return parentComponent == null ? ComponentUtil.findFrameWithIcon() : parentComponent;
    }

    private static String getTitleOfMessageType(int messageType) {
        return TITLE_OF_MESSAGE_TYPE.containsKey(messageType) ? TITLE_OF_MESSAGE_TYPE.get(messageType) : "";
    }

    static {
        TITLE_OF_MESSAGE_TYPE.put(0, Bundle.getString(MessageDisplayer.class, "MessageDisplayer.DefaultTitle.ErrorMessage", new Object[0]));
        TITLE_OF_MESSAGE_TYPE.put(2, Bundle.getString(MessageDisplayer.class, "MessageDisplayer.DefaultTitle.WarningMessage", new Object[0]));
        TITLE_OF_MESSAGE_TYPE.put(1, Bundle.getString(MessageDisplayer.class, "MessageDisplayer.DefaultTitle.Info", new Object[0]));
        TITLE_OF_MESSAGE_TYPE.put(3, Bundle.getString(MessageDisplayer.class, "MessageDisplayer.DefaultTitle.QuestionMessage", new Object[0]));
    }

    public static enum ConfirmAction {
        YES,
        NO,
        CANCEL;

    }
}

