/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.TextComponentSearchPanel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.ClipboardUtil;
import org.jphototagger.lib.util.SystemUtil;

public class LongMessageDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private String mailTo;
    private String mailSubject;
    private static final Map<Integer, String> ICON_KEY = new HashMap<Integer, String>();
    private JButton buttonClose;
    private JButton buttonCopy;
    private JButton buttonMail;
    private JLabel labelIcon;
    private JLabel labelShortMessage;
    private JPanel panelControls;
    private TextComponentSearchPanel panelSearch;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public LongMessageDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    private void init() {
        this.initComponents();
        MnemonicUtil.setMnemonics(this);
    }

    public void setMail(String to, String subject) {
        if (to == null) {
            throw new NullPointerException("to == null");
        }
        if (subject == null) {
            throw new NullPointerException("subject == null");
        }
        this.mailTo = to;
        this.mailSubject = subject;
        this.buttonMail.setEnabled(SystemUtil.canMail());
    }

    public void setShortMessage(String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        this.labelShortMessage.setText(message);
    }

    public void setLongMessage(String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        this.textArea.setText(message);
    }

    public void setErrorIcon() {
        this.labelIcon.setIcon(UIManager.getIcon(ICON_KEY.get(0)));
    }

    public void setWarningIcon() {
        this.labelIcon.setIcon(UIManager.getIcon(ICON_KEY.get(2)));
    }

    public void setInformationIcon() {
        this.labelIcon.setIcon(UIManager.getIcon(ICON_KEY.get(1)));
    }

    public void setQuestionIcon() {
        this.labelIcon.setIcon(UIManager.getIcon(ICON_KEY.get(3)));
    }

    private void copyToClipboard() {
        ClipboardUtil.copyToSystemClipboard(this.textArea.getText(), null);
    }

    private void sendMail() {
        try {
            URI uri = new URI("mailto", this.mailTo + "?subject=" + this.mailSubject, null);
            Desktop.getDesktop().mail(uri);
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, t);
        }
    }

    private void initComponents() {
        this.labelIcon = new JLabel();
        this.labelShortMessage = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.panelControls = new JPanel();
        this.panelSearch = new TextComponentSearchPanel();
        this.panelSearch.setSearchableTextComponent(this.textArea);
        this.buttonMail = new JButton();
        this.buttonCopy = new JButton();
        this.buttonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelIcon.setName("labelIcon");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labelIcon, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.labelShortMessage.setText(bundle.getString("LongMessageDialog.labelShortMessage.text"));
        this.labelShortMessage.setName("labelShortMessage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.getContentPane().add((Component)this.labelShortMessage, gridBagConstraints);
        this.scrollPane.setName("scrollPane");
        this.textArea.setColumns(20);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(5);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setName("textArea");
        this.scrollPane.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        this.panelControls.setName("panelControls");
        this.panelSearch.setName("panelSearch");
        this.buttonMail.setText(bundle.getString("LongMessageDialog.buttonMail.text"));
        this.buttonMail.setToolTipText(bundle.getString("LongMessageDialog.buttonMail.toolTipText"));
        this.buttonMail.setEnabled(false);
        this.buttonMail.setName("buttonMail");
        this.buttonMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongMessageDialog.this.buttonMailActionPerformed(evt);
            }
        });
        this.buttonCopy.setText(bundle.getString("LongMessageDialog.buttonCopy.text"));
        this.buttonCopy.setToolTipText(bundle.getString("LongMessageDialog.buttonCopy.toolTipText"));
        this.buttonCopy.setName("buttonCopy");
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongMessageDialog.this.buttonCopyActionPerformed(evt);
            }
        });
        this.buttonClose.setText(bundle.getString("LongMessageDialog.buttonClose.text"));
        this.buttonClose.setToolTipText(bundle.getString("LongMessageDialog.buttonClose.toolTipText"));
        this.buttonClose.setName("buttonClose");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LongMessageDialog.this.buttonCloseActionPerformed(evt);
            }
        });
        GroupLayout panelControlsLayout = new GroupLayout(this.panelControls);
        this.panelControls.setLayout(panelControlsLayout);
        panelControlsLayout.setHorizontalGroup(panelControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSearch, -1, 390, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelControlsLayout.createSequentialGroup().addContainerGap().addComponent(this.buttonMail).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose)));
        panelControlsLayout.linkSize(0, this.buttonClose, this.buttonCopy, this.buttonMail);
        panelControlsLayout.setVerticalGroup(panelControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelControlsLayout.createSequentialGroup().addComponent(this.panelSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelControlsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonClose).addComponent(this.buttonCopy).addComponent(this.buttonMail))));
        panelControlsLayout.linkSize(1, this.buttonClose, this.buttonCopy, this.buttonMail, this.panelSearch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panelControls, gridBagConstraints);
        this.pack();
    }

    private void buttonCopyActionPerformed(ActionEvent evt) {
        this.copyToClipboard();
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void buttonMailActionPerformed(ActionEvent evt) {
        this.sendMail();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LongMessageDialog dialog = new LongMessageDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    static {
        ICON_KEY.put(0, "OptionPane.errorIcon");
        ICON_KEY.put(3, "OptionPane.questionIcon");
        ICON_KEY.put(1, "OptionPane.informationIcon");
        ICON_KEY.put(2, "OptionPane.warningIcon");
    }
}

