/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public final class KeyEventUtil {
    private KeyEventUtil() {
    }

    public static boolean isCopy(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 67 && evt.getModifiers() == KeyEventUtil.getMenuShortcutMask();
    }

    public static boolean isCut(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 88 && evt.getModifiers() == KeyEventUtil.getMenuShortcutMask();
    }

    public static boolean isPaste(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 86 && evt.getModifiers() == KeyEventUtil.getMenuShortcutMask();
    }

    private static boolean isModifier(KeyEvent evt, int modifier) {
        int modifiers = evt.getModifiers();
        return (modifiers & modifier) == modifier;
    }

    private static boolean isKeyCode(KeyEvent evt, int keyCode) {
        return evt.getKeyCode() == keyCode;
    }

    public static boolean isMenuShortcutWithAlt(KeyEvent evt, int keyCode) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        int menuShortcutMask = KeyEventUtil.getMenuShortcutMask();
        return KeyEventUtil.isKeyCode(evt, keyCode) && (KeyEventUtil.isModifier(evt, menuShortcutMask | 0x200) || KeyEventUtil.isModifier(evt, menuShortcutMask | 8));
    }

    public static boolean isMenuShortcutWithShiftDown(KeyEvent evt, int keyCode) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        int menuShortcutMask = KeyEventUtil.getMenuShortcutMask();
        return KeyEventUtil.isKeyCode(evt, keyCode) && (KeyEventUtil.isModifier(evt, menuShortcutMask | 0x40) || KeyEventUtil.isModifier(evt, menuShortcutMask | 1));
    }

    public static boolean isMenuShortcut(KeyEvent evt, int keyCode) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == keyCode && evt.getModifiers() == KeyEventUtil.getMenuShortcutMask();
    }

    public static int getMenuShortcutMask() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static KeyStroke getKeyStroke(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, 0);
    }

    public static KeyStroke getKeyStrokeMenuShortcut(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, KeyEventUtil.getMenuShortcutMask());
    }

    public static KeyStroke getKeyStrokeMenuShortcutWithAltDown(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, KeyEventUtil.getMenuShortcutMask() | 0x200);
    }

    public static KeyStroke getKeyStrokeMenuShortcutWithShiftDown(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, KeyEventUtil.getMenuShortcutMask() | 0x40);
    }

    public static KeyStroke getKeyStrokeMenuShortcutWithShiftAltDown(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, KeyEventUtil.getMenuShortcutMask() | 0x40 | 0x200);
    }
}

