/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.ComponentUtil;

public final class InputDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JLabel labelPrompt;
    private JTextField textFieldInput;

    public InputDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
    }

    public InputDialog(JDialog owner) {
        super(owner, true);
        this.initComponents();
    }

    public InputDialog(String info, String input) {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.labelPrompt.setText(info);
        this.textFieldInput.setText(input);
    }

    public InputDialog(JDialog owner, String info, String input) {
        super(owner, true);
        this.initComponents();
        this.labelPrompt.setText(info);
        this.textFieldInput.setText(input);
    }

    public void setInfo(String info) {
        if (info == null) {
            throw new NullPointerException("info == null");
        }
        this.labelPrompt.setText(info);
    }

    public void setInput(String input) {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        this.textFieldInput.setText(input);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public String getInput() {
        return this.textFieldInput.getText();
    }

    @Override
    protected void escape() {
        this.accepted = false;
        this.setVisible(false);
    }

    private void initComponents() {
        this.labelPrompt = new JLabel();
        this.textFieldInput = new JTextField();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.setTitle(bundle.getString("InputDialog.title"));
        this.setName("Form");
        this.labelPrompt.setText(bundle.getString("InputDialog.labelPrompt.text"));
        this.labelPrompt.setName("labelPrompt");
        this.textFieldInput.setName("textFieldInput");
        this.textFieldInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InputDialog.this.textFieldInputKeyPressed(evt);
            }
        });
        this.buttonCancel.setMnemonic('a');
        this.buttonCancel.setText(bundle.getString("InputDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setMnemonic('o');
        this.buttonOk.setText(bundle.getString("InputDialog.buttonOk.text"));
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldInput, -1, 237, Short.MAX_VALUE).addComponent(this.labelPrompt).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelPrompt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldInput, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk).addComponent(this.buttonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.accepted = false;
        this.setVisible(false);
    }

    private void textFieldInputKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.accepted = true;
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputDialog dialog = new InputDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

