/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextArea;
import org.jphototagger.lib.swing.IconUtil;

public final class ImageTextArea
extends JTextArea
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private boolean consumeEnter;
    private Image image;
    private String imagePath;
    private boolean paintImage;

    public ImageTextArea() {
        this.listen();
    }

    private void listen() {
        this.addKeyListener(this);
    }

    public void setConsumeEnter(boolean consumeEnter) {
        this.consumeEnter = consumeEnter;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        if (imagePath == null) {
            throw new NullPointerException("imagePath == null");
        }
        this.imagePath = imagePath;
        this.image = IconUtil.getIconImage(imagePath);
        this.paintImage = this.image != null;
        this.setOpaque(false);
    }

    public void setImage(Image image) {
        this.paintImage = image != null;
        this.image = image;
        this.imagePath = null;
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawImage(g);
        super.paintComponent(g);
    }

    private void drawImage(Graphics g) {
        if (this.paintImage) {
            int thisHeight;
            int imgHeight = this.image.getHeight(this);
            int imgY = imgHeight >= (thisHeight = this.getHeight()) ? 0 : (int)((double)(thisHeight - imgHeight) / 2.0 + 0.5);
            g.drawImage(this.image, 0, imgY, this);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        this.paintImage = this.getDocument().getLength() <= 0 && evt.getKeyChar() < '\u0014';
        this.setOpaque(!this.paintImage);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent evt) {
        if (this.consumeEnter && evt.getID() == 401 && evt.getKeyCode() == 10) {
            evt.consume();
        } else {
            super.processComponentKeyEvent(evt);
        }
    }
}

