/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image image;
    private String imageIsAbsentText;

    public void setImage(Image image) {
        Image oldImage = this.image;
        this.image = image;
        this.firePropertyChange("image", oldImage, image);
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public String getImageIsAbsentText() {
        return this.imageIsAbsentText;
    }

    public void setImageIsAbsentText(String imageIsAbsentText) {
        String oldText = this.imageIsAbsentText;
        this.imageIsAbsentText = imageIsAbsentText;
        this.firePropertyChange("imageIsAbsentText", oldText, imageIsAbsentText);
    }

    @Override
    public void paint(Graphics g) {
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        this.eraseBackground(g, panelWidth, panelHeight);
        if (this.image != null) {
            this.drawImage(panelWidth, panelHeight, g);
        } else {
            this.drawImageIsAbsentText(g);
        }
    }

    private void eraseBackground(Graphics g, int panelWidth, int panelHeight) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, panelWidth, panelHeight);
    }

    private void drawImage(int panelWidth, int panelHeight, Graphics g) {
        Dimension imgageDimension = this.scaleImageIfSizeExceedsPanel();
        int imageWidth = imgageDimension.width;
        int imageHeight = imgageDimension.height;
        int x = this.getImageX(imageWidth, panelWidth);
        int y = this.getImageY(imageHeight, panelHeight);
        g.drawImage(this.image, x, y, this);
    }

    private int getImageX(int imageWidth, int panelWidth) {
        return imageWidth < panelWidth ? (panelWidth - imageWidth) / 2 : 0;
    }

    private int getImageY(int imageHeight, int panelHeight) {
        return imageHeight < panelHeight ? (panelHeight - imageHeight) / 2 : 0;
    }

    private Dimension scaleImageIfSizeExceedsPanel() {
        double scaleFactor;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int imageHeight = this.image.getHeight(this);
        int imageWidth = this.image.getWidth(this);
        if ((imageHeight > panelHeight || imageWidth > panelWidth) && (scaleFactor = this.getMaxScaleFactor(this.image)) != 0.0) {
            int scaledWidth = (int)((double)imageWidth * scaleFactor);
            int scaledHeight = (int)((double)imageHeight * scaleFactor);
            this.image = this.image.getScaledInstance(scaledWidth, scaledHeight, 4);
            imageHeight = this.image.getHeight(this);
            imageWidth = this.image.getWidth(this);
        }
        return new Dimension(imageWidth, imageHeight);
    }

    private double getMaxScaleFactor(Image image) {
        double panelHeight;
        boolean panelIsLandscape;
        double imageWidth = image.getWidth(this);
        double imageHeight = image.getHeight(this);
        double panelWidth = this.getWidth();
        boolean bl = panelIsLandscape = panelWidth > (panelHeight = (double)this.getHeight());
        if (panelIsLandscape) {
            double scaleFactor = panelHeight / imageHeight;
            double newImageWidth = imageWidth * scaleFactor;
            return newImageWidth <= panelWidth ? scaleFactor : panelWidth / imageWidth;
        }
        double scaleFactor = panelWidth / imageWidth;
        double newImageHeight = imageHeight * scaleFactor;
        return newImageHeight <= panelHeight ? scaleFactor : panelHeight / imageHeight;
    }

    private void drawImageIsAbsentText(Graphics g) {
        if (this.imageIsAbsentText == null) {
            return;
        }
        double panelWidth = this.getWidth();
        double panelHeight = this.getHeight();
        FontMetrics fm = g.getFontMetrics();
        double textWidth = fm.stringWidth(this.imageIsAbsentText);
        double textHeight = fm.getAscent();
        int x = 0;
        int y = (int)textHeight;
        if (textWidth < panelWidth) {
            x = (int)((panelWidth - textWidth) / 2.0 + 0.5);
        }
        if (textHeight < panelHeight) {
            y = (int)(textHeight + (panelHeight - textHeight) / 2.0 + 0.5);
        }
        g.setColor(this.getForeground());
        g.drawString(this.imageIsAbsentText, x, y);
    }
}

