/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Image;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public final class IconUtil {
    public static Image getIconImage(String path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        URL imgURL = IconUtil.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        Logger.getLogger(IconUtil.class.getName()).log(Level.SEVERE, null, "Image path not found: " + path);
        return null;
    }

    public static ImageIcon getImageIcon(String path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        URL imgURL = IconUtil.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        Logger.getLogger(IconUtil.class.getName()).log(Level.SEVERE, null, "Image path not found: " + path);
        return null;
    }

    public static ImageIcon getImageIcon(Class<?> clazz, String iconName) {
        if (clazz == null) {
            throw new NullPointerException("clazz == null");
        }
        if (iconName == null) {
            throw new NullPointerException("iconName == null");
        }
        String packagePath = IconUtil.resolvePackagePathForResource(clazz);
        return IconUtil.getImageIcon('/' + packagePath + '/' + iconName);
    }

    private static String resolvePackagePathForResource(Class<?> clazz) {
        String className = clazz.getName();
        int indexLastDot = className.lastIndexOf(46);
        if (indexLastDot < 1) {
            return "";
        }
        String packagePath = className.substring(0, indexLastDot);
        return packagePath.replace(".", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getSystemIcon(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Icon icon = null;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (file.exists()) {
            FileSystemView fileSystemView2 = fileSystemView;
            synchronized (fileSystemView2) {
                try {
                    icon = fileSystemView.getSystemIcon(file);
                }
                catch (Throwable t) {
                    Logger.getLogger(IconUtil.class.getName()).log(Level.SEVERE, null, t);
                }
            }
        }
        return icon;
    }

    private IconUtil() {
    }
}

