/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import javax.swing.JFrame;
import org.jphototagger.lib.awt.EventQueueUtil;

public final class GlassPaneWaitCursor {
    private final MouseAdapter mouseAdapter = new MouseAdapter(){};
    private final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private final Cursor defaultCursor = Cursor.getDefaultCursor();
    private volatile boolean mouseListenerAdded;
    private volatile boolean isShow;
    private final Object monitor = new Object();
    private final JFrame frame;

    public GlassPaneWaitCursor(JFrame frame) {
        if (frame == null) {
            throw new NullPointerException("frame == null");
        }
        this.frame = frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        Object object = this.monitor;
        synchronized (object) {
            this.addMouseListener();
        }
        this.show(true, this.waitCursor);
    }

    public void hide() {
        this.show(false, this.defaultCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShow() {
        Object object = this.monitor;
        synchronized (object) {
            return this.isShow;
        }
    }

    private void show(final boolean show, final Cursor cursor) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GlassPaneWaitCursor.this.monitor;
                synchronized (object) {
                    Component glassPane = GlassPaneWaitCursor.this.frame.getGlassPane();
                    glassPane.setCursor(cursor);
                    glassPane.setVisible(show);
                    GlassPaneWaitCursor.this.isShow = show;
                }
            }
        });
    }

    private void addMouseListener() {
        if (!this.mouseListenerAdded) {
            this.mouseListenerAdded = true;
            Component glassPane = this.frame.getGlassPane();
            glassPane.addMouseListener(this.mouseAdapter);
        }
    }
}

