/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.filechooser.FileSystemView;

public final class FileSystemListCellRenderer
extends DefaultListCellRenderer {
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    private static final long serialVersionUID = 1L;
    private final boolean absolutePathName;

    public FileSystemListCellRenderer(boolean absolutePathName) {
        this.absolutePathName = absolutePathName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof File) {
            File file = (File)value;
            if (file.exists()) {
                FileSystemView fileSystemView = FILE_SYSTEM_VIEW;
                synchronized (fileSystemView) {
                    try {
                        label.setIcon(FILE_SYSTEM_VIEW.getSystemIcon(file));
                    }
                    catch (Throwable t) {
                        Logger.getLogger(FileSystemListCellRenderer.class.getName()).log(Level.WARNING, null, t);
                    }
                }
            }
            label.setText(this.absolutePathName ? file.getAbsolutePath() : file.getName());
        }
        return label;
    }
}

