/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import org.jphototagger.lib.swing.FileChooserExt;
import org.jphototagger.lib.swing.FileChooserProperties;
import org.jphototagger.lib.util.Settings;

public final class FileChooserHelper {
    public static List<File> chooseFiles(FileChooserProperties fcProperties) {
        ArrayList<File> files = new ArrayList<File>();
        FileChooserExt fc = FileChooserHelper.getFileChooser(fcProperties);
        FileChooserHelper.applySize(fc, fcProperties);
        boolean open = FileChooserHelper.isOpen(fcProperties);
        if (open && FileChooserHelper.open(fc, fcProperties)) {
            files.addAll(Arrays.asList(fc.getSelectedFiles()));
        } else if (!open && FileChooserHelper.save(fc, fcProperties)) {
            files.addAll(Arrays.asList(fc.getSelectedFiles()));
        }
        FileChooserHelper.writeSize(fc, fcProperties);
        FileChooserHelper.writeCurrentDirectoryPath(files, fcProperties);
        return files;
    }

    private static boolean open(JFileChooser fc, FileChooserProperties p) {
        return fc.showOpenDialog(FileChooserHelper.getParent(p)) == 0;
    }

    private static boolean save(JFileChooser fc, FileChooserProperties p) {
        return fc.showSaveDialog(FileChooserHelper.getParent(p)) == 0;
    }

    private static FileChooserExt getFileChooser(FileChooserProperties p) {
        FileChooserExt fc = new FileChooserExt(FileChooserHelper.getCurrentDirectoryPath(p));
        if (p != null) {
            if (p.getDialogTitle() != null) {
                fc.setDialogTitle(p.getDialogTitle());
            }
            if (p.getFileFilter() != null) {
                fc.setFileFilter(p.getFileFilter());
                fc.setAcceptAllFileFilterUsed(false);
            }
            if (p.getSaveFilenameExtension() != null) {
                fc.setSaveFilenameExtension(p.getSaveFilenameExtension());
            }
            fc.setMultiSelectionEnabled(p.isMultiSelectionEnabled());
            fc.setConfirmOverwrite(p.isConfirmOverwrite());
            fc.setFileSelectionMode(p.getFileSelectionMode());
        }
        return fc;
    }

    private static Component getParent(FileChooserProperties p) {
        return p == null ? null : p.getParent();
    }

    private static boolean isOpen(FileChooserProperties p) {
        return p == null ? true : p.isOpen();
    }

    private static void writeCurrentDirectoryPath(List<File> files, FileChooserProperties p) {
        if (FileChooserHelper.canWriteProperties(p) && !files.isEmpty()) {
            p.getProperties().setProperty(FileChooserHelper.getKeyCurrentDirectoryPath(p), files.get(0).getAbsolutePath());
        }
    }

    private static String getCurrentDirectoryPath(FileChooserProperties p) {
        String dp;
        if (p == null) {
            return "";
        }
        if (p.getCurrentDirectoryPath() != null) {
            return p.getCurrentDirectoryPath();
        }
        if (FileChooserHelper.canWriteProperties(p) && (dp = p.getProperties().getProperty(FileChooserHelper.getKeyCurrentDirectoryPath(p))) != null) {
            return dp;
        }
        return "";
    }

    private static String getKeyCurrentDirectoryPath(FileChooserProperties p) {
        assert (FileChooserHelper.canWriteProperties(p));
        return p.getPropertyKeyPrefix() + ".CurrentDirectoryPath";
    }

    private static void applySize(JFileChooser fc, FileChooserProperties p) {
        if (FileChooserHelper.canWriteProperties(p)) {
            Settings settings = new Settings(p.getProperties());
            int width = settings.getInt(p.getPropertyKeyPrefix() + ".Width");
            int height = settings.getInt(p.getPropertyKeyPrefix() + ".Height");
            if (width > 0 && height > 0) {
                fc.setPreferredSize(new Dimension(width, height));
            }
        }
    }

    private static void writeSize(JFileChooser fc, FileChooserProperties p) {
        if (FileChooserHelper.canWriteProperties(p)) {
            Settings settings = new Settings(p.getProperties());
            settings.set(p.getPropertyKeyPrefix() + ".Width", fc.getWidth());
            settings.set(p.getPropertyKeyPrefix() + ".Height", fc.getHeight());
        }
    }

    private static boolean canWriteProperties(FileChooserProperties p) {
        return p != null && p.getPropertyKeyPrefix() != null && p.getProperties() != null;
    }

    public static File chooseFile(FileChooserProperties fcProperties) {
        List<File> files;
        if (fcProperties != null) {
            fcProperties.multiSelectionEnabled(false);
        }
        return (files = FileChooserHelper.chooseFiles(fcProperties)).isEmpty() ? null : files.get(0);
    }

    private FileChooserHelper() {
    }
}

