/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.jphototagger.lib.util.Bundle;

public final class FileChooserExt
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private boolean confirmOverwrite;
    private String saveFilenameExtension;

    public FileChooserExt(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public FileChooserExt(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public FileChooserExt(FileSystemView fsv) {
        super(fsv);
    }

    public FileChooserExt(File currentDirectory) {
        super(currentDirectory);
    }

    public FileChooserExt(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public FileChooserExt() {
    }

    public boolean isConfirmOverwrite() {
        return this.confirmOverwrite;
    }

    public void setConfirmOverwrite(boolean confirmOverwrite) {
        this.confirmOverwrite = confirmOverwrite;
    }

    public void setSaveFilenameExtension(String extension) {
        String string = this.saveFilenameExtension = extension == null ? null : extension;
        if (this.saveFilenameExtension != null && this.saveFilenameExtension.isEmpty()) {
            this.saveFilenameExtension = null;
        }
    }

    @Override
    public void approveSelection() {
        if (this.isSave() && this.confirmOverwrite && this.selSaveFileExists()) {
            if (this.confirmOverwrite()) {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    private boolean isSave() {
        return this.getDialogType() == 1;
    }

    private boolean selSaveFileExists() {
        if (this.isMultiSelectionEnabled()) {
            for (File selFile : this.getSelectedFiles()) {
                if (!this.saveFileExists(selFile)) continue;
                return true;
            }
            return false;
        }
        File selFile = this.getSelectedFile();
        return selFile == null ? false : this.saveFileExists(selFile);
    }

    private boolean saveFileExists(File file) {
        if (this.saveFilenameExtension == null) {
            return file.exists();
        }
        String path = file.getPath();
        if (path.toLowerCase().endsWith(this.saveFilenameExtension.toLowerCase())) {
            return file.exists();
        }
        return new File(path + this.saveFilenameExtension).exists();
    }

    private boolean confirmOverwrite() {
        boolean multiSel = this.isMultiSelectionEnabled();
        String question = multiSel ? Bundle.getString(FileChooserExt.class, "FileChooserExt.Confirm.OverwriteMultiSel", new Object[0]) : Bundle.getString(FileChooserExt.class, "FileChooserExt.Confirm.OverwriteSingleSel", new Object[0]);
        String title = Bundle.getString(FileChooserExt.class, "FileChooserExt.Confirm.OverwriteTitle", new Object[0]);
        int optionType = 0;
        return JOptionPane.showConfirmDialog(null, question, title, optionType) == 0;
    }

    @Override
    public File[] getSelectedFiles() {
        File[] selFiles = this.getSelFiles();
        int length = selFiles.length;
        for (int i = 0; i < length; ++i) {
            selFiles[i] = this.ensureSaveFilenameExtension(selFiles[i]);
        }
        return selFiles;
    }

    private File[] getSelFiles() {
        if (this.isMultiSelectionEnabled()) {
            return super.getSelectedFiles();
        }
        File selFile = this.getSelectedFile();
        if (selFile == null) {
            return new File[0];
        }
        return new File[]{selFile};
    }

    @Override
    public File getSelectedFile() {
        return this.ensureSaveFilenameExtension(super.getSelectedFile());
    }

    private File ensureSaveFilenameExtension(File file) {
        String path;
        if (file != null && this.saveFilenameExtension != null && this.isSave() && !(path = file.getPath()).toLowerCase().endsWith(this.saveFilenameExtension.toLowerCase())) {
            return new File(path + this.saveFilenameExtension);
        }
        return file;
    }
}

