/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class ExpandCollapseComponentPanel
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private static final String ICON_PATH_EXPAND = "/org/jphototagger/lib/resource/icons/icon_expand.png";
    private static final String ICON_PATH_COLLAPSE = "/org/jphototagger/lib/resource/icons/icon_collapse.png";
    private static final ImageIcon ICON_EXPAND = IconUtil.getImageIcon("/org/jphototagger/lib/resource/icons/icon_expand.png");
    private static final ImageIcon ICON_COLLAPSE = IconUtil.getImageIcon("/org/jphototagger/lib/resource/icons/icon_collapse.png");
    private static final String TOOLTIP_TEXT_EXPAND = Bundle.getString(ExpandCollapseComponentPanel.class, "ExpandCollapseComponentPanel.TooltipTextExpand", new Object[0]);
    private static final String TOOLTIP_TEXT_COLLAPSE = Bundle.getString(ExpandCollapseComponentPanel.class, "ExpandCollapseComponentPanel.TooltipTextCollapse", new Object[0]);
    private String keyPersistence = "";
    private final Component component;
    private JLabel labelFill;
    private String fillText;
    private Font fillFont;
    private boolean expanded = true;
    private JButton buttonExpandCollapse;

    public ExpandCollapseComponentPanel(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.component = component;
        this.initComponents();
        this.createFillLabel();
        this.addAsFocusListener();
        this.setPersistenceKey();
        this.addComponent(component);
        this.decorateButton();
    }

    private void addComponent(Component c) {
        this.add(c, this.createComponentConstraints());
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        return gbc;
    }

    private void collapseComponent() {
        this.remove(this.component);
        this.addComponent(this.labelFill);
        this.decorateButton();
        this.redraw();
    }

    private void expandComponent() {
        this.remove(this.labelFill);
        this.addComponent(this.component);
        this.decorateButton();
        this.redraw();
    }

    private void decorateButton() {
        this.buttonExpandCollapse.setIcon(this.expanded ? ICON_COLLAPSE : ICON_EXPAND);
        this.buttonExpandCollapse.setToolTipText(this.expanded ? TOOLTIP_TEXT_COLLAPSE : TOOLTIP_TEXT_EXPAND);
        this.buttonExpandCollapse.setMnemonic(this.expanded ? (char)'-' : '+');
    }

    private void setPersistenceKey() {
        String labelFillText = this.labelFill.getText().trim();
        assert (!labelFillText.isEmpty());
        if (!labelFillText.isEmpty()) {
            this.keyPersistence = ExpandCollapseComponentPanel.class.getCanonicalName() + labelFillText;
        }
    }

    private void writeExpandedState() {
        if (!this.keyPersistence.isEmpty()) {
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            prefs.setBoolean(this.keyPersistence, this.expanded);
        }
    }

    public void readExpandedState() {
        Preferences prefs;
        if (!this.keyPersistence.isEmpty() && (prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class)).containsKey(this.keyPersistence)) {
            this.expanded = prefs.getBoolean(this.keyPersistence);
            this.setExpanded();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void toggleExpandCollapse() {
        this.expanded = !this.expanded;
        this.writeExpandedState();
        this.setExpanded();
    }

    private void setExpanded() {
        if (this.expanded) {
            this.expandComponent();
        } else {
            this.collapseComponent();
        }
    }

    private void redraw() {
        this.validate();
        this.getParent().validate();
    }

    private void createFillLabel() {
        if (this.component instanceof Container) {
            Container container = (Container)this.component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component containerComponent = container.getComponent(i);
                if (!(containerComponent instanceof JLabel)) continue;
                JLabel label = (JLabel)containerComponent;
                this.fillText = label.getText();
                this.fillFont = label.getFont();
                this.labelFill = new JLabel(this.fillText);
                this.labelFill.setFont(this.fillFont);
                return;
            }
        }
        this.labelFill = new JLabel();
    }

    private void addAsFocusListener() {
        if (this.component instanceof Container) {
            Container container = (Container)this.component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component containerComponent = container.getComponent(i);
                if (!(containerComponent instanceof JTextComponent)) continue;
                containerComponent.addFocusListener(this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        Object source = evt.getSource();
        if (!this.expanded && source instanceof JTextComponent) {
            ((JTextComponent)source).transferFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
    }

    private void initComponents() {
        this.buttonExpandCollapse = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.buttonExpandCollapse.setBorder(BorderFactory.createLineBorder(new Color(125, 125, 125)));
        this.buttonExpandCollapse.setContentAreaFilled(false);
        this.buttonExpandCollapse.setFocusable(false);
        this.buttonExpandCollapse.setMargin(new Insets(0, 0, 0, 0));
        this.buttonExpandCollapse.setName("buttonExpandCollapse");
        this.buttonExpandCollapse.setPreferredSize(new Dimension(12, 12));
        this.buttonExpandCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpandCollapseComponentPanel.this.buttonExpandCollapseActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.buttonExpandCollapse, gridBagConstraints);
    }

    private void buttonExpandCollapseActionPerformed(ActionEvent evt) {
        this.toggleExpandCollapse();
    }
}

