/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeCellRenderer;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeModel;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DirectoryChooser
extends Dialog
implements TreeSelectionListener,
PopupMenuListener {
    private static final long serialVersionUID = 1L;
    private final File startDirectory;
    private final List<Option> options;
    private final AllSystemDirectoriesTreeModel model;
    private boolean accepted;
    private boolean titleSet;
    private JButton buttonAdd;
    private JButton buttonCancel;
    private JButton buttonChoose;
    private JButton buttonDelete;
    private JButton buttonRefresh;
    private JButton buttonRename;
    private JLabel labelUsage;
    private JMenuItem menuItemAdd;
    private JMenuItem menuItemDelete;
    private JMenuItem menuItemRename;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPane;
    private JTree tree;

    public DirectoryChooser(Frame parent, File startDirectory, Option ... options) {
        this(parent, startDirectory, Collections.emptyList(), options);
    }

    public DirectoryChooser(Frame parent, File startDirectory, Collection<? extends File> excludeRootDirectories, Option ... options) {
        super(parent, true);
        if (startDirectory == null) {
            throw new NullPointerException("startDirectory == null");
        }
        if (excludeRootDirectories == null) {
            throw new NullPointerException("excludeRootDirectories == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        this.startDirectory = startDirectory;
        this.options = Arrays.asList(options);
        this.initComponents();
        this.model = new AllSystemDirectoriesTreeModel(this.tree, excludeRootDirectories, this.getIsShowHiddenDirsFilter());
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.tree.setModel(this.model);
        this.tree.addTreeSelectionListener(this);
        this.popupMenu.addPopupMenuListener(this);
        MnemonicUtil.setMnemonics(this);
    }

    private void setSelectionMode() {
        this.tree.getSelectionModel().setSelectionMode(this.options.contains((Object)Option.MULTI_SELECTION) ? 4 : 1);
        this.setDefaultTitle();
        this.setUsageText();
    }

    private void setUsageText() {
        this.labelUsage.setText(this.options.contains((Object)Option.MULTI_SELECTION) ? Bundle.getString(DirectoryChooser.class, "DirectoryChooser.LabelUsage.MultipleSelection", new Object[0]) : Bundle.getString(DirectoryChooser.class, "DirectoryChooser.LabelUsage.SingleSelection", new Object[0]));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.titleSet = true;
    }

    private void setDefaultTitle() {
        if (this.titleSet) {
            return;
        }
        super.setTitle(this.options.contains((Object)Option.MULTI_SELECTION) ? Bundle.getString(DirectoryChooser.class, "DirectoryChooser.Title.MultipleSelection", new Object[0]) : Bundle.getString(DirectoryChooser.class, "DirectoryChooser.Title.SingleSelection", new Object[0]));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.restoreSizeAndLocation();
            this.setSelectionMode();
            this.selectStartDirectory();
            if (DirectoryChooser.lookupAutoScanDirectories()) {
                this.model.startAutoUpdate();
            }
        }
        super.setVisible(visible);
    }

    private static boolean lookupAutoScanDirectories() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("Preferences.Autoscan.Directories") ? prefs.getBoolean("Preferences.Autoscan.Directories") : false;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public List<File> getSelectedDirectories() {
        ArrayList<File> files = new ArrayList<File>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path1 : paths) {
                Object userObject;
                Object[] path = path1.getPath();
                int filecount = path.length;
                if (path == null || filecount < 1 || !((userObject = ((DefaultMutableTreeNode)path[filecount - 1]).getUserObject()) instanceof File)) continue;
                files.add((File)userObject);
            }
        }
        return files;
    }

    private void selectStartDirectory() {
        if (this.startDirectory.isDirectory()) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    DirectoryChooser.this.model.expandToFile(DirectoryChooser.this.startDirectory, true);
                }
            });
        }
    }

    private DirectoryFilter.Option getIsShowHiddenDirsFilter() {
        return this.options.contains((Object)Option.DISPLAY_HIDDEN_DIRECTORIES) ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private void cancel() {
        this.model.stopAutoUpdate();
        this.accepted = false;
        super.setVisible(false);
    }

    private void ok() {
        if (this.tree.getSelectionCount() > 0) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            Object userObject = selNode.getUserObject();
            if (userObject instanceof File) {
                this.accepted = true;
                this.model.stopAutoUpdate();
                super.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this, Bundle.getString(DirectoryChooser.class, "DirectoryChooser.Error.NoDirectoryChosen", new Object[0]), Bundle.getString(DirectoryChooser.class, "DirectoryChooser.Error.NoDirectoryChosen.Title", new Object[0]), 0);
            }
        }
    }

    @Override
    protected void escape() {
        this.model.stopAutoUpdate();
        super.escape();
    }

    private void refresh() {
        this.model.update();
    }

    private void addDirectory() {
        TreePath[] selPaths = this.tree.getSelectionPaths();
        this.model.createDirectoryIn(TreeFileSystemDirectories.getNodeOfLastPathComponent(selPaths[0]));
    }

    private void renameDirectory() {
        TreePath[] selPaths;
        for (TreePath treePath : selPaths = this.tree.getSelectionPaths()) {
            File newDir;
            File dir;
            DefaultMutableTreeNode node = TreeFileSystemDirectories.getNodeOfLastPathComponent(treePath);
            File file = dir = node == null ? null : TreeFileSystemDirectories.getFile(node);
            if (dir == null || (newDir = TreeFileSystemDirectories.rename(dir)) == null) continue;
            node.setUserObject(newDir);
            TreeFileSystemDirectories.updateInTreeModel(this.model, node);
        }
    }

    private void deleteDirectory() {
        TreePath[] selPaths;
        for (TreePath treePath : selPaths = this.tree.getSelectionPaths()) {
            File dir;
            DefaultMutableTreeNode node = TreeFileSystemDirectories.getNodeOfLastPathComponent(treePath);
            File file = dir = node == null ? null : TreeFileSystemDirectories.getFile(node);
            if (dir == null || !TreeFileSystemDirectories.delete(dir)) continue;
            TreeFileSystemDirectories.removeFromTreeModel(this.model, node);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        Object node = this.tree.getLastSelectedPathComponent();
        boolean allDirOptionsPossible = this.allDirActionsPossible();
        this.menuItemAdd.setEnabled(!this.isWorkspace(node));
        this.menuItemDelete.setEnabled(allDirOptionsPossible && this.isDeleteDirectoriesEnabled());
        this.menuItemRename.setEnabled(allDirOptionsPossible);
    }

    private boolean isDeleteDirectoriesEnabled() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs != null && prefs.containsKey("Preferences.Enable.DeleteDirectories") ? prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object node = this.tree.getLastSelectedPathComponent();
        boolean allDirActionsPossible = this.allDirActionsPossible();
        boolean isWorkspace = this.isWorkspace(node);
        this.buttonAdd.setEnabled(!isWorkspace);
        this.buttonChoose.setEnabled(!isWorkspace);
        this.buttonDelete.setEnabled(allDirActionsPossible && this.isDeleteDirectoriesEnabled());
        this.buttonRename.setEnabled(allDirActionsPossible);
    }

    private boolean allDirActionsPossible() {
        Object node = this.tree.getLastSelectedPathComponent();
        return node != null && !this.isWorkspace(node) && !this.isRootFile(node);
    }

    private boolean isWorkspace(Object o) {
        return o == this.tree.getModel().getRoot();
    }

    private boolean isRootFile(Object o) {
        if (o instanceof DefaultMutableTreeNode) {
            Object rootNode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            TreeNode parentNode = node.getParent();
            return parentNode == (rootNode = this.tree.getModel().getRoot());
        }
        return false;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemAdd = new JMenuItem();
        this.menuItemRename = new JMenuItem();
        this.menuItemDelete = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.tree = new JTree();
        this.labelUsage = new JLabel();
        this.buttonRefresh = new JButton();
        this.buttonAdd = new JButton();
        this.buttonDelete = new JButton();
        this.buttonRename = new JButton();
        this.buttonCancel = new JButton();
        this.buttonChoose = new JButton();
        this.popupMenu.setName("popupMenu");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.menuItemAdd.setText(bundle.getString("DirectoryChooser.menuItemAdd.text"));
        this.menuItemAdd.setName("menuItemAdd");
        this.menuItemAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.menuItemAddActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemAdd);
        this.menuItemRename.setText(bundle.getString("DirectoryChooser.menuItemRename.text"));
        this.menuItemRename.setName("menuItemRename");
        this.menuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.menuItemRenameActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemRename);
        this.menuItemDelete.setText(bundle.getString("DirectoryChooser.menuItemDelete.text"));
        this.menuItemDelete.setName("menuItemDelete");
        this.menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.menuItemDeleteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDelete);
        this.setDefaultCloseOperation(0);
        this.setTitle(bundle.getString("DirectoryChooser.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DirectoryChooser.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setName("scrollPane");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.tree.setCellRenderer(new AllSystemDirectoriesTreeCellRenderer());
        this.tree.setComponentPopupMenu(this.popupMenu);
        this.tree.setName("Tree directory chooser");
        this.scrollPane.setViewportView(this.tree);
        this.labelUsage.setText(bundle.getString("DirectoryChooser.labelUsage.text"));
        this.labelUsage.setName("labelUsage");
        this.buttonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_refresh.png")));
        this.buttonRefresh.setToolTipText(bundle.getString("DirectoryChooser.buttonRefresh.toolTipText"));
        this.buttonRefresh.setName("buttonRefresh");
        this.buttonRefresh.setPreferredSize(new Dimension(25, 25));
        this.buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonRefreshActionPerformed(evt);
            }
        });
        this.buttonAdd.setText(bundle.getString("DirectoryChooser.buttonAdd.text"));
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setName("buttonAdd");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonAddActionPerformed(evt);
            }
        });
        this.buttonDelete.setText(bundle.getString("DirectoryChooser.buttonDelete.text"));
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setName("buttonDelete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.buttonRename.setText(bundle.getString("DirectoryChooser.buttonRename.text"));
        this.buttonRename.setEnabled(false);
        this.buttonRename.setName("buttonRename");
        this.buttonRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonRenameActionPerformed(evt);
            }
        });
        this.buttonCancel.setMnemonic('b');
        this.buttonCancel.setText(bundle.getString("DirectoryChooser.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonChoose.setMnemonic('a');
        this.buttonChoose.setText(bundle.getString("DirectoryChooser.buttonChoose.text"));
        this.buttonChoose.setName("buttonChoose");
        this.buttonChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooser.this.buttonChooseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 418, Short.MAX_VALUE).addComponent(this.labelUsage, -1, 418, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonRefresh, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRename)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonChoose)))).addContainerGap()));
        layout.linkSize(0, this.buttonAdd, this.buttonCancel, this.buttonChoose, this.buttonDelete, this.buttonRename);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 238, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelUsage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonAdd).addComponent(this.buttonDelete).addComponent(this.buttonRename)).addComponent(this.buttonRefresh, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonChoose).addComponent(this.buttonCancel)).addContainerGap()));
        layout.linkSize(1, this.buttonAdd, this.buttonCancel, this.buttonChoose, this.buttonDelete, this.buttonRefresh, this.buttonRename);
        this.pack();
    }

    private void buttonChooseActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    private void buttonRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void menuItemAddActionPerformed(ActionEvent evt) {
        this.addDirectory();
    }

    private void menuItemRenameActionPerformed(ActionEvent evt) {
        this.renameDirectory();
    }

    private void menuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteDirectory();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.addDirectory();
    }

    private void buttonRenameActionPerformed(ActionEvent evt) {
        this.renameDirectory();
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.deleteDirectory();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DirectoryChooser dialog = new DirectoryChooser((Frame)new JFrame(), new File(""), new Option[0]);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static enum Option {
        DISPLAY_HIDDEN_DIRECTORIES,
        MULTI_SELECTION,
        NO_OPTION;

    }
}

