/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.help.HelpUtil;
import org.openide.util.Lookup;

public class Dialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private transient ActionListener actionListenerEscape;
    private transient ActionListener actionListenerHelp;
    private String helpPageUrl;
    private String preferencesKey;
    private boolean ignorePersistedSizeAndLocation;
    private final WindowListener sizeAndLocationPersister = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent evt) {
            Dialog.this.persistSizeAndLocation();
        }
    };

    public Dialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public Dialog(JDialog owner, boolean modal) {
        super((java.awt.Dialog)owner, modal);
        this.init();
    }

    public Dialog(Frame owner) {
        super(owner);
        this.init();
    }

    public Dialog(JDialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.createActionListener();
        this.registerKeyboardActions();
        this.addWindowListener(this.sizeAndLocationPersister);
    }

    public void setHelpPageUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        this.helpPageUrl = url;
    }

    protected void showHelp() {
        if (this.helpPageUrl != null) {
            this.showHelp(this.helpPageUrl);
        }
    }

    protected void showHelp(String url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        HelpUtil.showHelp(url);
    }

    protected void escape() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.restoreSizeAndLocation();
        } else {
            this.persistSizeAndLocation();
        }
        super.setVisible(visible);
    }

    public void setPreferencesKey(String preferencesKey) {
        this.preferencesKey = preferencesKey;
    }

    public void setIgnorePersistedSizeAndLocation(boolean ignore) {
        this.ignorePersistedSizeAndLocation = ignore;
    }

    protected void persistSizeAndLocation() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (this.ignorePersistedSizeAndLocation || prefs == null) {
            return;
        }
        String key = this.getSizeAndLocationPreferencesKey();
        prefs.setSize(key, (Component)this);
        prefs.setLocation(key, (Component)this);
    }

    protected void restoreSizeAndLocation() {
        if (this.ignorePersistedSizeAndLocation) {
            return;
        }
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs == null) {
            this.setLocationRelativeTo(null);
            return;
        }
        String key = this.getSizeAndLocationPreferencesKey();
        prefs.applySize(key, (Component)this);
        prefs.applyLocation(key, (Component)this);
    }

    private String getSizeAndLocationPreferencesKey() {
        return this.preferencesKey == null ? this.getClass().getName() : this.preferencesKey;
    }

    private void registerKeyboardActions() {
        KeyStroke strokeEscape = KeyStroke.getKeyStroke(27, 0);
        KeyStroke strokeHelp = KeyStroke.getKeyStroke(112, 0);
        for (Component component : this.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.registerKeyboardAction(this.actionListenerEscape, strokeEscape, 2);
            jComponent.registerKeyboardAction(this.actionListenerHelp, strokeHelp, 2);
        }
    }

    private void createActionListener() {
        this.actionListenerEscape = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.escape();
            }
        };
        this.actionListenerHelp = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.showHelp();
            }
        };
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke strokeEscape = KeyStroke.getKeyStroke(27, 0);
        KeyStroke strokeHelp = KeyStroke.getKeyStroke(112, 0);
        JRootPane pane = new JRootPane();
        pane.registerKeyboardAction(this.actionListenerEscape, strokeEscape, 2);
        pane.registerKeyboardAction(this.actionListenerHelp, strokeHelp, 2);
        return pane;
    }
}

