/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import javax.swing.Icon;
import javax.swing.JLabel;
import org.jphototagger.lib.swing.IconUtil;

public final class BooleanLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Icon trueIcon = IconUtil.getImageIcon(BooleanLabel.class, "icon_boolean_true.png");
    private Icon falseIcon = IconUtil.getImageIcon(BooleanLabel.class, "icon_boolean_false.png");
    private String trueText;
    private String falseText;
    private Boolean isTrue;

    public BooleanLabel() {
        this("");
    }

    public BooleanLabel(String text) {
        super(text);
        this.setIcon(this.falseIcon);
    }

    public Icon getFalseIcon() {
        return this.falseIcon;
    }

    public void setFalseIcon(Icon falseIcon) {
        Icon old = this.falseIcon;
        this.falseIcon = falseIcon;
        this.firePropertyChange("falseIcon", old, this.falseIcon);
    }

    public Icon getTrueIcon() {
        return this.trueIcon;
    }

    public void setTrueIcon(Icon trueIcon) {
        Icon old = this.trueIcon;
        this.trueIcon = trueIcon;
        this.firePropertyChange("trueIcon", old, this.trueIcon);
    }

    public Boolean isTrue() {
        return this.isTrue;
    }

    public void setIsTrue(Boolean isTrue) {
        Boolean old = this.isTrue;
        this.isTrue = isTrue;
        this.setIcon(isTrue != false ? this.trueIcon : this.falseIcon);
        this.firePropertyChange("isTrue", old, this.isTrue);
    }

    @Override
    public String getText() {
        if (this.trueText != null && this.falseText != null) {
            return this.isTrue == null ? this.falseText : (this.isTrue != false ? this.trueText : this.falseText);
        }
        return super.getText();
    }

    public String getTrueText() {
        return this.trueText;
    }

    public void setTrueText(String trueText) {
        String oldTrueText = this.trueText;
        String oldText = this.getText();
        this.trueText = trueText;
        this.firePropertyChange("trueText", oldTrueText, this.trueText);
        this.firePropertyChange("text", oldText, this.getText());
    }

    public String getFalseText() {
        return this.falseText;
    }

    public void setFalseText(String falseText) {
        String oldFalseText = this.falseText;
        String oldText = this.getText();
        this.falseText = falseText;
        this.firePropertyChange("falseText", oldFalseText, this.falseText);
        this.firePropertyChange("text", oldText, this.getText());
    }
}

