/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.SortedChildrenTreeNode;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.StringUtil;

public final class AllSystemDirectoriesTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AllSystemDirectoriesTreeModel.class.getName());
    private static final long UPDATE_INTERVAL_MILLISECONDS = 2000L;
    private static final Object DUMMY = new Object();
    private final DirectoryFilter directoryFilter;
    private final DefaultMutableTreeNode rootNode;
    private final JTree tree;
    private final List<File> excludedRootDirs = new ArrayList<File>();
    private final ScheduledExecutorService updateScheduler;
    private volatile boolean autoupdate;
    private final Runnable updater = new Runnable(){
        private final AtomicInteger taskCount = new AtomicInteger(0);

        @Override
        public void run() {
            if (this.taskCount.intValue() > 0) {
                return;
            }
            this.addNewRoots();
            this.update(AllSystemDirectoriesTreeModel.this.getTreeRowNodes());
        }

        private void addNewRoots() {
            this.taskCount.incrementAndGet();
            final File[] rootFiles = File.listRoots();
            if (rootFiles == null) {
                this.taskCount.decrementAndGet();
                return;
            }
            final List childDirectories = AllSystemDirectoriesTreeModel.getChildDirectories(AllSystemDirectoriesTreeModel.this.rootNode);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (File rootFile : rootFiles) {
                        boolean isExclude = AllSystemDirectoriesTreeModel.this.excludedRootDirs.contains(rootFile);
                        if (isExclude || !rootFile.isDirectory() || childDirectories.contains(rootFile)) continue;
                        DefaultMutableTreeNode child = AllSystemDirectoriesTreeModel.this.addChildDirectory(AllSystemDirectoriesTreeModel.this.rootNode, rootFile);
                        AllSystemDirectoriesTreeModel.this.addDummy(child);
                    }
                    taskCount.decrementAndGet();
                }
            });
        }

        private void update(Collection<? extends DefaultMutableTreeNode> nodes) {
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
                this.updateRemoveDummy(defaultMutableTreeNode);
                Object userObject = defaultMutableTreeNode.getUserObject();
                if (!(userObject instanceof File)) continue;
                File dir = (File)userObject;
                if (!dir.exists()) {
                    this.remove(defaultMutableTreeNode);
                    continue;
                }
                this.addNewChildren(defaultMutableTreeNode);
            }
        }

        private void updateRemoveDummy(final DefaultMutableTreeNode node) {
            this.taskCount.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AllSystemDirectoriesTreeModel.this.removeDummy(node, true);
                    taskCount.decrementAndGet();
                }
            });
        }

        private void remove(final DefaultMutableTreeNode node) {
            this.taskCount.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AllSystemDirectoriesTreeModel.this.removeNodeFromParent(node);
                    taskCount.decrementAndGet();
                }
            });
        }

        private void addNewChildren(final DefaultMutableTreeNode node) {
            this.taskCount.incrementAndGet();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof File)) {
                this.taskCount.decrementAndGet();
                return;
            }
            if (!TreeUtil.isNodeExpanded(AllSystemDirectoriesTreeModel.this.tree, node)) {
                AllSystemDirectoriesTreeModel.this.addDummy(node);
                this.taskCount.decrementAndGet();
                return;
            }
            final List childDirectories = AllSystemDirectoriesTreeModel.getChildDirectories(node);
            final List<File> directories = FileUtil.listFiles((File)userObject, AllSystemDirectoriesTreeModel.this.directoryFilter);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (File directory : directories) {
                        if (childDirectories.contains(directory) || !FileUtil.isReadableDirectory(directory)) continue;
                        DefaultMutableTreeNode child = AllSystemDirectoriesTreeModel.this.addChildDirectory(node, directory);
                        AllSystemDirectoriesTreeModel.this.addDummy(child);
                    }
                    taskCount.decrementAndGet();
                }
            });
        }
    };
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("JPhotoTagger: System Directories Tree Update");
            return thread;
        }
    };

    public AllSystemDirectoriesTreeModel(JTree tree, Collection<? extends File> excludedRootDirectories, DirectoryFilter.Option ... directoryFilterOptions) {
        super(new SortedChildrenTreeNode("Root of TreeModelAllSystemDirectories"));
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        this.tree = tree;
        this.directoryFilter = new DirectoryFilter(directoryFilterOptions);
        this.excludedRootDirs.addAll(excludedRootDirectories);
        this.addRootDirectories();
        this.listen();
        this.updateScheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
    }

    private void listen() {
        this.tree.addTreeWillExpandListener(this);
    }

    private void addRootDirectories() {
        LOGGER.log(Level.FINEST, "Reading root directories...");
        Object[] roots = File.listRoots();
        LOGGER.log(Level.FINEST, "Root directories have been read: {0}", StringUtil.toString(roots));
        LOGGER.log(Level.FINEST, "Root directories to exclude: {0}: ", this.excludedRootDirs);
        if (roots == null) {
            return;
        }
        List<Object> rootDirs = Arrays.asList(roots);
        for (File file : rootDirs) {
            if (this.excludedRootDirs.contains(file) || !FileUtil.isReadableDirectory(file)) continue;
            SortedChildrenTreeNode rootDirNode = new SortedChildrenTreeNode(file);
            this.insertNodeInto(rootDirNode, this.rootNode, this.rootNode.getChildCount());
            this.addDummy(rootDirNode);
        }
    }

    private void addChildren(DefaultMutableTreeNode parentNode) {
        File parentDir;
        Object userObject = parentNode.getUserObject();
        File file = parentDir = userObject instanceof File ? (File)userObject : null;
        if (!FileUtil.isReadableDirectory(parentDir)) {
            return;
        }
        LOGGER.log(Level.FINEST, "Reading subdirectories of ''{0}''...", parentDir);
        Object[] subdirs = parentDir.listFiles(this.directoryFilter);
        LOGGER.log(Level.FINEST, "Subdirectories of ''{0}'' has been read: {1}", new Object[]{parentDir, StringUtil.toString(subdirs)});
        this.removeDummy(parentNode, false);
        if (subdirs == null) {
            return;
        }
        List<File> parentNodeChildDirectories = AllSystemDirectoriesTreeModel.getChildDirectories(parentNode);
        for (Object subdir : subdirs) {
            if (parentNodeChildDirectories.contains(subdir) || !FileUtil.isReadableDirectory((File)subdir)) continue;
            DefaultMutableTreeNode childNode = this.addChildDirectory(parentNode, (File)subdir);
            this.addDummy(childNode);
        }
    }

    private static List<File> getChildDirectories(DefaultMutableTreeNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        int childCount = node.getChildCount();
        ArrayList<File> childFiles = new ArrayList<File>(childCount);
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            Object childNodeUserObject = childNode.getUserObject();
            if (!(childNodeUserObject instanceof File)) continue;
            childFiles.add((File)childNodeUserObject);
        }
        return childFiles;
    }

    private DefaultMutableTreeNode addChildDirectory(DefaultMutableTreeNode parentNode, File directory) {
        LOGGER.log(Level.FINEST, "Adding subdirectory ''{0}'' to node ''{1}''", new Object[]{directory, parentNode});
        SortedChildrenTreeNode newChildNode = new SortedChildrenTreeNode(directory);
        parentNode.add(newChildNode);
        int newChildIndex = parentNode.getIndex(newChildNode);
        this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{newChildIndex}, new Object[]{newChildNode});
        LOGGER.log(Level.FINEST, "Subdirectory ''{0}'' has been added to node ''{1}''", new Object[]{directory, parentNode});
        return newChildNode;
    }

    private void addDummy(DefaultMutableTreeNode parentNode) {
        Object userObject = parentNode.getUserObject();
        if (parentNode.isLeaf() && userObject instanceof File && FileUtil.containsReadableDirectory((File)userObject)) {
            SortedChildrenTreeNode dummy = new SortedChildrenTreeNode(DUMMY);
            parentNode.add(dummy);
            this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{0}, new Object[]{dummy});
        }
    }

    private void removeDummy(DefaultMutableTreeNode parentNode, boolean onlyIfEmptyDir) {
        if (this.containsDummy(parentNode)) {
            Object userObject;
            TreeNode dummyChild = parentNode.getChildAt(0);
            boolean remove = true;
            if (onlyIfEmptyDir && (userObject = parentNode.getUserObject()) instanceof File) {
                boolean bl = remove = !FileUtil.containsReadableDirectory((File)userObject);
            }
            if (remove) {
                parentNode.remove(0);
                this.fireTreeNodesRemoved(this, parentNode.getPath(), new int[]{0}, new Object[]{dummyChild});
            }
        }
    }

    private boolean containsDummy(DefaultMutableTreeNode node) {
        return node.getChildCount() == 1 && ((DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() == DUMMY;
    }

    public File createDirectoryIn(DefaultMutableTreeNode parentNode) {
        File createdDirectory;
        File parentNodeDirectory;
        File file = parentNodeDirectory = parentNode == null ? null : TreeFileSystemDirectories.getFile(parentNode);
        if (parentNodeDirectory != null && (createdDirectory = TreeFileSystemDirectories.createDirectoryIn(parentNodeDirectory)) != null) {
            SortedChildrenTreeNode createdDirNode = new SortedChildrenTreeNode(createdDirectory);
            parentNode.add(createdDirNode);
            int childIndex = parentNode.getIndex(createdDirNode);
            this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{childIndex}, new Object[]{createdDirNode});
            return createdDirectory;
        }
        return null;
    }

    public void expandToFile(File file, boolean select) {
        Stack<File> filePath = FileUtil.getPathFromRoot(file);
        DefaultMutableTreeNode node = this.rootNode;
        this.tree.expandPath(new TreePath(node.getPath()));
        while (node != null && !filePath.isEmpty()) {
            if ((node = TreeUtil.findChildNodeWithFile(node, filePath.pop())) == null || filePath.size() <= 0) continue;
            this.tree.expandPath(new TreePath(node.getPath()));
        }
        if (node != null) {
            TreePath nodePath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(nodePath);
            if (select) {
                this.tree.setSelectionPath(nodePath);
            }
        }
    }

    public void update() {
        Cursor treeCursor = this.tree.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.tree.setCursor(waitCursor);
        for (DefaultMutableTreeNode node : this.getTreeRowNodes()) {
            TreeNode parent = node.getParent();
            this.removeChildrenWithNotExistingFiles((DefaultMutableTreeNode)parent);
            this.addChildren((DefaultMutableTreeNode)parent);
            Enumeration<? extends TreeNode> e = parent.children();
            while (e.hasMoreElements()) {
                TreeNode sibling = e.nextElement();
                this.addDummy((DefaultMutableTreeNode)sibling);
            }
        }
        this.tree.setCursor(treeCursor);
    }

    private int removeChildrenWithNotExistingFiles(DefaultMutableTreeNode parentNode) {
        int childCount = parentNode.getChildCount();
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (this.containsDummy(child)) {
                this.removeDummy(child, true);
            }
            Object userObject = child.getUserObject();
            File file = null;
            if (userObject instanceof File) {
                file = (File)userObject;
            }
            if (file == null || file.exists()) continue;
            nodesToRemove.add(child);
        }
        for (DefaultMutableTreeNode childNodeToRemove : nodesToRemove) {
            LOGGER.log(Level.FINEST, "Removing child node ''{0}'' from parent node ''{1}''...", new Object[]{childNodeToRemove, parentNode});
            this.removeNodeFromParent(childNodeToRemove);
            LOGGER.log(Level.FINEST, "Child node ''{0}'' has been removed from parent node ''{1}''", new Object[]{childNodeToRemove, parentNode});
        }
        return nodesToRemove.size();
    }

    private List<DefaultMutableTreeNode> getTreeRowNodes() {
        int rowCount = this.tree.getRowCount();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            nodes.add((DefaultMutableTreeNode)this.tree.getPathForRow(i).getLastPathComponent());
        }
        return nodes;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Cursor treeCursor = this.tree.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.tree.setCursor(waitCursor);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        LOGGER.log(Level.FINEST, "Node ''{0}'' has been expanded, adding children...", node);
        this.addChildren(node);
        LOGGER.log(Level.FINEST, "Children were added to node ''{0}'' after expanding", node);
        this.tree.setCursor(treeCursor);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutoUpdate() {
        ScheduledExecutorService scheduledExecutorService = this.updateScheduler;
        synchronized (scheduledExecutorService) {
            if (!this.autoupdate) {
                this.updateScheduler.scheduleWithFixedDelay(this.updater, 0L, 2000L, TimeUnit.MILLISECONDS);
                this.autoupdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAutoUpdate() {
        ScheduledExecutorService scheduledExecutorService = this.updateScheduler;
        synchronized (scheduledExecutorService) {
            if (this.autoupdate) {
                this.updateScheduler.shutdown();
                this.autoupdate = false;
            }
        }
    }
}

