/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.LookAndFeelUtil;
import org.jphototagger.lib.util.Bundle;

public final class AllSystemDirectoriesTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AllSystemDirectoriesTreeCellRenderer.class.getName());
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    private static final Icon ROOT_ICON = IconUtil.getImageIcon("/org/jphototagger/lib/resource/icons/icon_workspace.png");
    private static final String DISPLAY_NAME_ROOT = Bundle.getString(AllSystemDirectoriesTreeCellRenderer.class, "AllSystemDirectoriesTreeCellRenderer.DisplayName.Root", new Object[0]);
    private static final Color TREE_SELECTION_FOREGROUND = LookAndFeelUtil.getUiColor("Tree.selectionForeground");
    private static final Color TREE_SELECTION_BACKGROUND = LookAndFeelUtil.getUiColor("Tree.selectionBackground");
    private static final Color TREE_TEXT_BACKGROUND = LookAndFeelUtil.getUiColor("Tree.textBackground");
    private static final Color TREE_TEXT_FOREGROUND = LookAndFeelUtil.getUiColor("Tree.textForeground");
    private int tempSelRow = -1;

    public AllSystemDirectoriesTreeCellRenderer() {
        this.setOpaque(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, hasFocus);
        if (value == tree.getModel().getRoot()) {
            this.setIcon(ROOT_ICON);
            this.setText(DISPLAY_NAME_ROOT);
        } else if (value instanceof DefaultMutableTreeNode) {
            boolean fileExists;
            File file = null;
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof File) {
                file = (File)userObject;
            }
            boolean bl = fileExists = file != null && file.exists();
            if (fileExists) {
                FileSystemView fileSystemView = FILE_SYSTEM_VIEW;
                synchronized (fileSystemView) {
                    try {
                        this.setIcon(FILE_SYSTEM_VIEW.getSystemIcon(file));
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                }
                this.setText(this.getDirectoryName(file));
            } else if (file != null) {
                this.setText('?' + file.getName() + '?');
            }
        }
        this.setColors(tree, row, this.selected);
        return this;
    }

    private String getDirectoryName(File file) {
        String name = file.getName();
        if (name.isEmpty() && (name = file.getAbsolutePath()).endsWith("\\")) {
            return name.substring(0, name.length() - 2) + ":";
        }
        return this.getDisplayname(file);
    }

    public void setTempSelectionRow(int index) {
        this.tempSelRow = index;
    }

    private void setColors(JTree tree, int row, boolean selected) {
        boolean tempSelExists = this.tempSelRow >= 0;
        boolean isTempSelRow = row == this.tempSelRow;
        boolean isDragging = this.isDragging(tree, row);
        boolean selection = isTempSelRow || selected && !tempSelExists || isDragging;
        this.setForeground(selection ? TREE_SELECTION_FOREGROUND : TREE_TEXT_FOREGROUND);
        this.setBackground(selection ? TREE_SELECTION_BACKGROUND : TREE_TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDisplayname(File file) {
        FileSystemView fileSystemView = FILE_SYSTEM_VIEW;
        synchronized (fileSystemView) {
            try {
                String displayName = FILE_SYSTEM_VIEW.getSystemDisplayName(file);
                return displayName == null ? file.getName() : displayName;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, null, t);
                return file.getName();
            }
        }
    }

    private boolean isDragging(JTree tree, int row) {
        JTree.DropLocation dropLocation = tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
    }
}

