/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.runtime.ProcessResult;

public final class External {
    public static void execute(String command) {
        if (command == null) {
            throw new NullPointerException("command == null");
        }
        try {
            Process process = Runtime.getRuntime().exec(External.parseQuotedCommandLine(command));
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            Thread outputGobblerThread = new Thread(new StreamGobbler(inputStream));
            Thread errorGobblerThread = new Thread(new StreamGobbler(errorStream));
            outputGobblerThread.setName("JPhotoTagger: Consuming stdout of " + command);
            errorGobblerThread.setName("JPhotoTagger: Consuming stderr of " + command);
            errorGobblerThread.start();
            outputGobblerThread.start();
        }
        catch (Throwable t) {
            Logger.getLogger(External.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult executeWaitForTermination(String command, long maxMillisecondsUntilDestroy) {
        if (command == null) {
            throw new NullPointerException("command == null");
        }
        if (maxMillisecondsUntilDestroy < 0L) {
            throw new IllegalArgumentException("Negative maximum milliseconds until destroy: " + maxMillisecondsUntilDestroy);
        }
        Timer timer = new Timer(true);
        try {
            InterruptTimerTask interrupter = new InterruptTimerTask(Thread.currentThread());
            timer.schedule((TimerTask)interrupter, maxMillisecondsUntilDestroy);
            Process process = Runtime.getRuntime().exec(External.parseQuotedCommandLine(command));
            ProcessResult processResult = External.waitForTermination(process, command, maxMillisecondsUntilDestroy);
            return processResult;
        }
        catch (Throwable t) {
            Logger.getLogger(External.class.getName()).log(Level.SEVERE, null, t);
            ProcessResult processResult = null;
            return processResult;
        }
        finally {
            timer.cancel();
            Thread.interrupted();
        }
    }

    private static ProcessResult waitForTermination(Process process, String command, long maxMillisecondsUntilDestroy) {
        StreamReader stdOutStreamReader = new StreamReader(process.getInputStream());
        Thread stdOutReaderThread = new Thread(stdOutStreamReader);
        StreamReader stdErrStreamReader = new StreamReader(process.getErrorStream());
        Thread stdErrReaderThread = new Thread(stdErrStreamReader);
        stdOutReaderThread.setName("JPhotoTagger: Reading stdout of " + command);
        stdErrReaderThread.setName("JPhotoTagger: Reading stderr of " + command);
        stdOutReaderThread.start();
        stdErrReaderThread.start();
        try {
            int processExitValue = process.waitFor();
            byte[] stdOutBytes = stdOutStreamReader.readStreamBytes;
            byte[] stdErrBytes = stdErrStreamReader.readStreamBytes;
            return new ProcessResult(stdOutBytes, stdErrBytes, processExitValue);
        }
        catch (InterruptedException ex) {
            process.destroy();
            Logger.getLogger(External.class.getName()).log(Level.SEVERE, "The command {1} did run more than {0} milliseconds and was terminated.", new Object[]{maxMillisecondsUntilDestroy, command});
            return null;
        }
    }

    public static String[] parseQuotedCommandLine(String command) throws IOException {
        if (command == null) {
            throw new NullPointerException("command == null");
        }
        String cmd = command.replace("\\", "\\\\");
        String[] cmd_array = new String[]{};
        StreamTokenizer st = new StreamTokenizer(new StringReader(cmd));
        st.resetSyntax();
        st.wordChars(0, 65535);
        st.whitespaceChars(32, 32);
        st.quoteChar(34);
        int i = 0;
        while (st.nextToken() != -1) {
            String[] new_cmd_array = new String[i + 1];
            new_cmd_array[i] = st.sval;
            System.arraycopy(cmd_array, 0, new_cmd_array, 0, i);
            cmd_array = new_cmd_array;
            ++i;
        }
        return cmd_array;
    }

    private External() {
    }

    private static class StreamReader
    implements Runnable {
        private static final int BUFFER_SIZE = 102400;
        private final byte[] streamBuffer = new byte[102400];
        private final InputStream stream;
        private byte[] readStreamBytes = null;

        private StreamReader(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                int numberOfBytesRead;
                do {
                    if ((numberOfBytesRead = this.stream.read(this.streamBuffer, 0, 102400)) <= 0) continue;
                    if (this.readStreamBytes == null) {
                        this.readStreamBytes = new byte[numberOfBytesRead];
                        System.arraycopy(this.streamBuffer, 0, this.readStreamBytes, 0, numberOfBytesRead);
                        continue;
                    }
                    this.readStreamBytes = StreamReader.createMergedByteArray(this.readStreamBytes, this.streamBuffer, numberOfBytesRead);
                } while (numberOfBytesRead >= 0);
            }
            catch (Throwable t) {
                Logger.getLogger(External.class.getName()).log(Level.SEVERE, null, t);
            }
        }

        private static byte[] createMergedByteArray(byte[] array1, byte[] array2, int readNumberOfBytesInArray2) {
            byte[] newArray = new byte[array1.length + readNumberOfBytesInArray2];
            System.arraycopy(array1, 0, newArray, 0, array1.length);
            System.arraycopy(array2, 0, newArray, array1.length, readNumberOfBytesInArray2);
            return newArray;
        }
    }

    private static class InterruptTimerTask
    extends TimerTask {
        private final Thread thread;

        private InterruptTimerTask(Thread t) {
            this.thread = t;
        }

        @Override
        public void run() {
            this.thread.interrupt();
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;

        private StreamGobbler(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while (bufferedReader.readLine() != null) {
                }
            }
            catch (Throwable t) {
                try {
                    Logger.getLogger(External.class.getName()).log(Level.WARNING, null, t);
                }
                catch (Throwable throwable) {
                    IoUtil.close(bufferedReader);
                    throw throwable;
                }
                IoUtil.close(bufferedReader);
            }
            IoUtil.close(bufferedReader);
        }
    }
}

