/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jphototagger.lib.net.HttpUtil;
import org.jphototagger.lib.util.Version;

public final class NetVersion {
    public static Version getOverHttp(String httpUrl, String versionDelimiter) throws MalformedURLException, IOException, NumberFormatException, IllegalArgumentException {
        if (httpUrl == null) {
            throw new NullPointerException("httpUrl == null");
        }
        if (versionDelimiter == null) {
            throw new NullPointerException("versionDelimiter == null");
        }
        URL url = new URL(httpUrl);
        ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
        HttpUtil.write(url, os, null);
        String content = os.toString();
        int beginIndex = content.indexOf("<span class=\"version\">");
        if (beginIndex >= 0) {
            int endIndex = content.indexOf("</span>", beginIndex + 1);
            if (endIndex <= beginIndex) {
                return null;
            }
            String versionString = content.substring(beginIndex + 22, endIndex);
            return Version.parseVersion(versionString, versionDelimiter);
        }
        return null;
    }

    private NetVersion() {
    }
}

