/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jphototagger.api.concurrent.CancelRequest;

public final class HttpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(URL source, OutputStream target, CancelRequest cancelRequest) throws IOException {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        HttpURLConnection connection = null;
        BufferedInputStream inputStream = null;
        try {
            connection = (HttpURLConnection)source.openConnection();
            connection.setRequestProperty("Accept-Encoding", "zip, jar, exe");
            connection.connect();
            inputStream = new BufferedInputStream(HttpUtil.openConnectionCheckRedirects(connection));
            boolean cancel = false;
            int singleByte = inputStream.read();
            while (!cancel && singleByte != -1) {
                target.write(singleByte);
                cancel = cancelRequest == null ? false : cancelRequest.isCancel();
                singleByte = inputStream.read();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            target.flush();
            target.close();
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private HttpUtil() {
    }
}

