/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.lookup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.api.nodes.Node;
import org.jphototagger.lib.lookup.LookupUtil;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class LookupTree
extends JXTree
implements Lookup.Provider,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final InstanceContent selectionContent = new InstanceContent();
    private final Lookup selectionLookup = new AbstractLookup((AbstractLookup.Content)this.selectionContent);
    private final InstanceContent temporarySelectionContent = new InstanceContent();
    private final Lookup temporarySelectionLookup = new AbstractLookup((AbstractLookup.Content)this.temporarySelectionContent);
    private int lastSelectionCount = 0;
    private int lastRightClickRow = -1;

    public LookupTree() {
        this.addMouseListener(this);
    }

    public Lookup getLookup() {
        return this.selectionLookup;
    }

    public Lookup getTemporarySelectionLookup() {
        return this.temporarySelectionLookup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int currentSelectionCount = this.getSelectionCount();
        Collection<?> selectedContent = LookupUtil.createContentOfSelectedValues((JTree)((Object)this));
        int rightClickRow = this.getRowForLocation(e.getX(), e.getY());
        if (!MouseEventUtil.isPopupTrigger(e)) {
            if (rightClickRow != this.lastRightClickRow || this.lastSelectionCount != currentSelectionCount) {
                this.lastRightClickRow = rightClickRow;
                this.selectionContent.set(selectedContent, null);
            }
            this.lastSelectionCount = currentSelectionCount;
            return;
        }
        this.lastSelectionCount = currentSelectionCount;
        if (this.isRowSelected(rightClickRow)) {
            boolean isTemporarySelection = false;
            this.showPopupMenu(e.getX(), e.getY(), selectedContent, isTemporarySelection);
        } else {
            Object temporarySelectedValue = LookupUtil.getTreeContentAtRow((JTree)((Object)this), rightClickRow);
            List<Object> temporarySelectedContent = Arrays.asList(temporarySelectedValue);
            this.temporarySelectionContent.set(temporarySelectedContent, null);
            boolean isTemporarySelection = true;
            this.showPopupMenu(e.getX(), e.getY(), temporarySelectedContent, isTemporarySelection);
            LookupUtil.clearInstanceContent(this.temporarySelectionContent);
        }
    }

    void showPopupMenu(int x, int y, Collection<?> selectedContent, boolean temporary) {
        JPopupMenu popupMenu = LookupUtil.createPopupMenuFromNodeActions(selectedContent, temporary);
        if (popupMenu != null) {
            popupMenu.show((Component)((Object)this), x, y);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath treePath;
        Object lastPathComponent;
        if (MouseEventUtil.isDoubleClick(e) && (lastPathComponent = (treePath = TreeUtil.getTreePath(e)).getLastPathComponent()) instanceof Node) {
            Node node = (Node)lastPathComponent;
            this.performPreferredActionOfNode(node);
        }
    }

    private void performPreferredActionOfNode(Node node) {
        Action preferredAction = node.getPreferredAction();
        if (preferredAction != null) {
            preferredAction.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

