/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.lookup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.nodes.Node;
import org.jphototagger.lib.lookup.LookupUtil;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class LookupList
extends JXList
implements Lookup.Provider,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final InstanceContent selectionContent = new InstanceContent();
    private final Lookup selectionLookup = new AbstractLookup((AbstractLookup.Content)this.selectionContent);
    private final InstanceContent temporarySelectionContent = new InstanceContent();
    private final Lookup temporarySelectionLookup = new AbstractLookup((AbstractLookup.Content)this.temporarySelectionContent);
    private int lastSelectionCount = 0;
    private int lastRightClickIndex = -1;

    public LookupList() {
        this.addMouseListener(this);
    }

    public Lookup getLookup() {
        return this.selectionLookup;
    }

    public Lookup getTemporarySelectionLookup() {
        return this.temporarySelectionLookup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseCursorIndex = ListUtil.getItemIndex(e);
        int currentSelectionCount = ListUtil.getSelectionCount(this);
        Collection<?> selectedContent = LookupUtil.createContentOfSelectedValues(this);
        if (!MouseEventUtil.isPopupTrigger(e)) {
            if (mouseCursorIndex != this.lastRightClickIndex || this.lastSelectionCount != currentSelectionCount) {
                this.lastRightClickIndex = mouseCursorIndex;
                this.selectionContent.set(selectedContent, null);
            }
            this.lastSelectionCount = currentSelectionCount;
            return;
        }
        this.lastSelectionCount = currentSelectionCount;
        if (this.isSelectedIndex(mouseCursorIndex)) {
            boolean isTemporarySelection = false;
            this.showPopupMenu(e.getX(), e.getY(), selectedContent, isTemporarySelection);
        } else {
            Object temporarySelectedValue = super.getElementAt(mouseCursorIndex);
            List<Object> temporarySelectedContent = Arrays.asList(temporarySelectedValue);
            this.temporarySelectionContent.set(temporarySelectedContent, null);
            boolean isTemporarySelection = true;
            this.showPopupMenu(e.getX(), e.getY(), temporarySelectedContent, isTemporarySelection);
            LookupUtil.clearInstanceContent(this.temporarySelectionContent);
        }
    }

    void showPopupMenu(int x, int y, Collection<?> selectedContent, boolean temporary) {
        JPopupMenu popupMenu = LookupUtil.createPopupMenuFromNodeActions(selectedContent, temporary);
        if (popupMenu != null) {
            popupMenu.show((Component)((Object)this), x, y);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int itemIndex;
        if (MouseEventUtil.isDoubleClick(e) && (itemIndex = ListUtil.getItemIndex(e)) >= 0) {
            this.performPreferredActionAtItemIndex(itemIndex);
        }
    }

    private void performPreferredActionAtItemIndex(int itemIndex) {
        Object elementAtIndex = super.getElementAt(itemIndex);
        if (elementAtIndex instanceof Node) {
            Node nodeAtIndex = (Node)elementAtIndex;
            this.performPreferredActionOfNode(nodeAtIndex);
        }
    }

    private void performPreferredActionOfNode(Node node) {
        Action preferredAction = node.getPreferredAction();
        if (preferredAction != null) {
            preferredAction.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

