/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.lookup;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class LookupAction<T>
extends AbstractAction
implements LookupListener {
    private static final long serialVersionUID = 1L;
    private final Class<? extends T> lookupResultClass;
    private final Lookup lookup;
    private Lookup.Result<? extends T> lookupResult;

    protected LookupAction(Class<? extends T> lookupResultClass, Lookup lookup) {
        if (lookupResultClass == null) {
            throw new NullPointerException("lookupResultClass == null");
        }
        if (lookup == null) {
            throw new NullPointerException("lookup == null");
        }
        this.lookupResultClass = lookupResultClass;
        this.lookup = lookup;
        this.setLookupResult();
    }

    private void setLookupResult() {
        if (this.lookupResult == null) {
            this.lookupResult = this.lookup.lookupResult(this.lookupResultClass);
            this.lookupResult.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    public void resultChanged(LookupEvent evt) {
        this.setEnabledInDispatchThread();
    }

    private void setEnabledInDispatchThread() {
        final boolean isEnabled = this.isEnabled(this.lookupResult.allInstances());
        if (EventQueue.isDispatchThread()) {
            this.setEnabled(isEnabled);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LookupAction.this.setEnabled(isEnabled);
                }
            });
        }
    }

    protected Collection<? extends T> getLookupContent() {
        return this.lookupResult == null ? Collections.emptyList() : this.lookupResult.allInstances();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setLookupResult();
        this.actionPerformed(this.lookupResult.allInstances());
    }

    protected abstract boolean isEnabled(Collection<? extends T> var1);

    protected abstract void actionPerformed(Collection<? extends T> var1);
}

