/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jphototagger.api.component.DisplayNameProvider;
import org.jphototagger.lib.io.filefilter.FileChooserFilter;

public final class RegexFileFilter
implements FileFilter,
Serializable,
DisplayNameProvider {
    private static final long serialVersionUID = 1L;
    private final Set<String> acceptedPatterns = new HashSet<String>();
    private String displayname;

    public RegexFileFilter(RegexFileFilter other) {
        this.set(other);
    }

    public void set(RegexFileFilter other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.acceptedPatterns.clear();
        this.displayname = other.displayname;
        this.acceptedPatterns.addAll(other.acceptedPatterns);
    }

    public RegexFileFilter(String acceptedPatterns, String delim) {
        if (acceptedPatterns == null) {
            throw new NullPointerException("acceptedPatterns == null");
        }
        if (delim == null) {
            throw new NullPointerException("delim == null");
        }
        this.setAcceptedValues(acceptedPatterns, delim);
    }

    private void setAcceptedValues(String acceptedValueString, String delim) {
        StringTokenizer token = new StringTokenizer(acceptedValueString, delim);
        while (token.hasMoreElements()) {
            this.acceptedPatterns.add(token.nextToken());
        }
    }

    public void addAcceptPatternsOf(RegexFileFilter other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        if (other == this) {
            return;
        }
        this.acceptedPatterns.addAll(other.acceptedPatterns);
    }

    public void removeAcceptPatternsOf(RegexFileFilter other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        if (other == this) {
            return;
        }
        this.acceptedPatterns.removeAll(other.acceptedPatterns);
    }

    public void addAcceptPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        this.acceptedPatterns.add(pattern);
    }

    public void removeAcceptPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        this.acceptedPatterns.remove(pattern);
    }

    @Override
    public boolean accept(File file) {
        String pathname = file.getName();
        for (String pattern : this.acceptedPatterns) {
            if (!pathname.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getDisplayName() {
        return this.displayname == null ? this.acceptedPatterns.toString() : this.displayname;
    }

    public javax.swing.filechooser.FileFilter forFileChooser(String description) {
        return new FileChooserFilter(this, description);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegexFileFilter)) {
            return false;
        }
        RegexFileFilter other = (RegexFileFilter)obj;
        return this.acceptedPatterns.equals(other.acceptedPatterns);
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + this.acceptedPatterns.hashCode();
        return hash;
    }
}

