/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.jphototagger.lib.io.filefilter.FileChooserFilter;

public final class DirectoryFilter
implements FileFilter,
Serializable {
    public static final DirectoryFilter ACCEPT_HIDDEN_FILES = new DirectoryFilter(Option.ACCEPT_HIDDEN_FILES);
    public static final DirectoryFilter NO_OPTIONS = new DirectoryFilter(Option.NO_OPTION);
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    private static final long serialVersionUID = 1L;
    private final List<Option> options;

    public DirectoryFilter(Option ... options) {
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        this.options = Arrays.asList(options);
    }

    @Override
    public boolean accept(File file) {
        boolean isDirectory = file.isDirectory();
        return this.options.contains((Object)Option.ACCEPT_HIDDEN_FILES) ? isDirectory : isDirectory && !FILE_SYSTEM_VIEW.isHiddenFile(file);
    }

    public javax.swing.filechooser.FileFilter forFileChooser(String description) {
        return new FileChooserFilter(this, description);
    }

    public static enum Option {
        ACCEPT_HIDDEN_FILES,
        NO_OPTION;

    }
}

