/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import org.jphototagger.lib.io.filefilter.FileChooserFilter;

public final class AcceptExactFilenameFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private boolean ignoreCase = true;

    public AcceptExactFilenameFileFilter(String filename) {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        this.filename = filename;
    }

    public void setIgnoreCase(boolean ignore) {
        this.ignoreCase = ignore;
    }

    @Override
    public boolean accept(File file) {
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        return this.ignoreCase ? name.equalsIgnoreCase(this.filename) : name.equals(this.filename);
    }

    public javax.swing.filechooser.FileFilter forFileChooser(String description) {
        return new FileChooserFilter(this, description);
    }
}

