/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;

public final class TreeFileSystemDirectories {
    public static boolean delete(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory() && TreeFileSystemDirectories.confirmDelete(directory.getName())) {
            try {
                FileUtil.deleteDirectoryRecursive(directory);
                return true;
            }
            catch (Throwable t) {
                TreeFileSystemDirectories.errorMessageDelete(directory.getName());
                Logger.getLogger(TreeFileSystemDirectories.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return false;
    }

    public static File rename(File directory) {
        File newDirectory;
        String newDirectoryName;
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory() && (newDirectoryName = TreeFileSystemDirectories.getNewName(directory)) != null && !newDirectoryName.trim().isEmpty() && TreeFileSystemDirectories.checkDoesNotExist(newDirectory = new File(directory.getParentFile(), newDirectoryName))) {
            try {
                if (directory.renameTo(newDirectory)) {
                    return newDirectory;
                }
            }
            catch (Throwable t) {
                Logger.getLogger(TreeFileSystemDirectories.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    public static File createDirectoryIn(File parentDirectory) {
        File subdirectory;
        String subdirectoryName;
        if (parentDirectory == null) {
            throw new NullPointerException("parentDirectory == null");
        }
        if (parentDirectory.isDirectory() && (subdirectoryName = TreeFileSystemDirectories.getSubDirectoryName()) != null && !subdirectoryName.trim().isEmpty() && TreeFileSystemDirectories.checkDoesNotExist(subdirectory = new File(parentDirectory, subdirectoryName))) {
            try {
                if (subdirectory.mkdir()) {
                    return subdirectory;
                }
            }
            catch (Throwable t) {
                Logger.getLogger(TreeFileSystemDirectories.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    public static DefaultMutableTreeNode getNodeOfLastPathComponent(TreePath path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)lastPathComponent;
        }
        return null;
    }

    public static File getFile(DefaultMutableTreeNode node) {
        Object userObject;
        if (node != null && (userObject = node.getUserObject()) instanceof File) {
            return (File)userObject;
        }
        return null;
    }

    public static void updateInTreeModel(TreeModel model, MutableTreeNode node) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).nodeChanged(node);
        }
    }

    public static void insertIntoTreeModel(TreeModel model, DefaultMutableTreeNode parentNode, File file) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).insertNodeInto(new DefaultMutableTreeNode(file), parentNode, parentNode.getChildCount());
        }
    }

    public static void removeFromTreeModel(TreeModel model, MutableTreeNode node) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).removeNodeFromParent(node);
        }
    }

    public static String getNewName(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Frame parentFrame = ComponentUtil.findFrameWithIcon();
        String message = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Input.NewName", file);
        String initSelectionValue = file.getName();
        return JOptionPane.showInputDialog(parentFrame, message, initSelectionValue);
    }

    public static boolean checkDoesNotExist(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (file.exists()) {
            Frame parentFrame = ComponentUtil.findFrameWithIcon();
            String message = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Error.DirectoryAlreadyExists", file.getAbsolutePath());
            String title = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Error.DirectoryAlreadyExists.Title", new Object[0]);
            JOptionPane.showMessageDialog(parentFrame, message, title, 0);
            return false;
        }
        return true;
    }

    public static boolean confirmDelete(String directoryName) {
        int optionType;
        String title;
        if (directoryName == null) {
            throw new NullPointerException("directoryName == null");
        }
        Frame parentFrame = ComponentUtil.findFrameWithIcon();
        String message = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Confirm.Delete", directoryName);
        return JOptionPane.showConfirmDialog(parentFrame, message, title = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Confirm.Delete.Title", new Object[0]), optionType = 0) == 0;
    }

    public static void errorMessageDelete(String directoryName) {
        if (directoryName == null) {
            throw new NullPointerException("directoryName == null");
        }
        Frame parentFrame = ComponentUtil.findFrameWithIcon();
        String message = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Error.Delete", directoryName);
        String titel = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Error.Delete.Title", new Object[0]);
        int messageType = 0;
        JOptionPane.showMessageDialog(parentFrame, message, titel, messageType);
    }

    private static String getSubDirectoryName() {
        Frame parentFrame = ComponentUtil.findFrameWithIcon();
        String message = Bundle.getString(TreeFileSystemDirectories.class, "TreeFileSystemDirectories.Input.SubDirectoryName", new Object[0]);
        return JOptionPane.showInputDialog(parentFrame, (Object)message);
    }

    private TreeFileSystemDirectories() {
    }
}

