/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public final class PreviousSelectedFiles {
    private final String preferencesKey;
    private final int maxCount;
    private final Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);

    public PreviousSelectedFiles(String preferencesKey, int maxCount) {
        if (preferencesKey == null) {
            throw new NullPointerException("preferencesKey == null");
        }
        if (maxCount < 1) {
            throw new IllegalArgumentException("Maximum count has to be 1 or greater and not " + maxCount);
        }
        this.preferencesKey = preferencesKey;
        this.maxCount = maxCount;
    }

    public void add(File file) {
        if (file == null) {
            return;
        }
        LinkedList<File> files = new LinkedList<File>(this.getFiles());
        files.addFirst(file);
        if (files.size() > this.maxCount) {
            files.removeLast();
        }
        this.setFiles(files);
    }

    public void setFiles(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        int countAdded = 0;
        LinkedHashSet<String> pathnames = new LinkedHashSet<String>(files.size());
        for (File file : files) {
            if (countAdded > this.maxCount) break;
            pathnames.add(file.getAbsolutePath());
            ++countAdded;
        }
        this.preferences.setStringCollection(this.preferencesKey, pathnames);
    }

    public List<File> getFiles() {
        return this.getFiles(false);
    }

    public List<File> getExistingFiles() {
        return this.getFiles(true);
    }

    private List<File> getFiles(boolean onlyExisting) {
        List pathnames = this.preferences.getStringCollection(this.preferencesKey);
        LinkedHashSet<File> files = new LinkedHashSet<File>(pathnames.size());
        int countAdded = 0;
        for (int i = 0; i < pathnames.size() && countAdded <= this.maxCount; ++i) {
            File file = new File((String)pathnames.get(i));
            if (onlyExisting && !file.exists()) continue;
            files.add(file);
            ++countAdded;
        }
        return new ArrayList<File>(files);
    }

    public int getExistingFileCount() {
        return this.getExistingFiles().size();
    }

    public JPopupMenu createPopupMenu(Functor<File> functor, File ... skip) {
        if (functor == null) {
            throw new NullPointerException("functor == null");
        }
        HashSet<File> skipFiles = skip == null || skip.length == 0 ? Collections.emptySet() : new HashSet<File>(Arrays.asList(skip));
        JPopupMenu popupMenu = new JPopupMenu();
        for (File file : this.getExistingFiles()) {
            if (skipFiles.contains(file)) continue;
            popupMenu.add(new FileFunctorAction(file, functor));
        }
        return popupMenu;
    }

    public void clear() {
        this.preferences.removeStringCollection(this.preferencesKey);
    }

    private static final class FileFunctorAction
    extends AbstractAction {
        private static final int MAX_NAME_LENGTH = 125;
        private static final long serialVersionUID = 1L;
        private final File file;
        private final Functor<File> functor;

        private FileFunctorAction(File file, Functor<File> functor) {
            super(FileFunctorAction.createDisplayname(file));
            this.file = file;
            this.functor = functor;
        }

        private static String createDisplayname(File file) {
            String pathname = file.getAbsolutePath();
            return pathname.length() <= 125 ? pathname : StringUtil.getPrefixDotted(pathname, 125);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.functor.execute((Object)this.file);
        }
    }
}

