/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.util.SystemProperties;

public final class IoUtil {
    public static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException ex) {
                Logger.getLogger(IoUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextResource(String path) throws IOException {
        String string;
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        BufferedReader br = null;
        String newline = SystemProperties.getLineSeparator();
        try {
            String line;
            InputStream is = IoUtil.class.getResourceAsStream(path);
            InputStreamReader isr = new InputStreamReader(is);
            StringBuilder sb = new StringBuilder();
            boolean isFirstLine = true;
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(isFirstLine ? "" : newline);
                sb.append(line);
                isFirstLine = false;
            }
            if (sb.length() > 0) {
                sb.append(newline);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IoUtil.close(br);
            throw throwable;
        }
        IoUtil.close(br);
        return string;
    }

    public static void fromIsToOs(InputStream is, OutputStream os) throws IOException, InterruptedException {
        if (is == null) {
            throw new NullPointerException("is == null");
        }
        if (os == null) {
            throw new NullPointerException("os == null");
        }
        byte[] buffer = new byte[1024];
        int len = is.read(buffer);
        while (len != -1) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(InputStream is1, InputStream is2) throws IOException {
        if (is1 == null) {
            throw new NullPointerException("is1 == null");
        }
        if (is2 == null) {
            throw new NullPointerException("is2 == null");
        }
        int bufSize = 65536;
        byte[] buf1 = new byte[bufSize];
        byte[] buf2 = new byte[bufSize];
        try {
            int len;
            DataInputStream d2 = new DataInputStream(is2);
            while ((len = is1.read(buf1)) > 0) {
                d2.readFully(buf2, 0, len);
                for (int i = 0; i < len; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = d2.read() < 0;
            return bl;
        }
        finally {
            is1.close();
            is2.close();
        }
    }

    private IoUtil() {
    }
}

