/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.CancelRequest;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.Md5Util;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.lib.util.StringUtil;

public final class FileUtil {
    public static String getContentAsString(File file, String encoding) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding == null");
        }
        return new String(FileUtil.getContentAsBytes(file), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringAsFile(String string, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(string.getBytes());
        }
        catch (Throwable throwable) {
            IoUtil.close(fos);
            throw throwable;
        }
        IoUtil.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringAsFile(String string, String charsetName, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(string.getBytes(charsetName));
        }
        catch (Throwable throwable) {
            IoUtil.close(fos);
            throw throwable;
        }
        IoUtil.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentAsBytes(File file) throws IOException {
        byte[] byArray;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int byteCount = fileInputStream.available();
            byte[] bytes = new byte[byteCount];
            fileInputStream.read(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            IoUtil.close(fileInputStream);
            throw throwable;
        }
        IoUtil.close(fileInputStream);
        return byArray;
    }

    public static void ensureFileExists(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (file.exists()) {
            return;
        }
        File directory = file.getParentFile();
        FileUtil.ensureDirectoryExists(directory);
        if (!file.createNewFile()) {
            throw new IOException("File couldn't be created: " + file);
        }
    }

    public static boolean existsFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return file.exists() && !file.isDirectory();
    }

    public static void ensureDirectoryExists(File directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory()) {
            return;
        }
        if (!directory.mkdirs()) {
            throw new IOException("Directory couldn't be created: " + directory);
        }
    }

    public static boolean isWritableDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        return directory.isDirectory() && directory.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile == null");
        }
        if (targetFile == null) {
            throw new NullPointerException("targetFile == null");
        }
        if (sourceFile.equals(targetFile)) {
            return;
        }
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFile);
            inChannel = fis.getChannel();
            fos = new FileOutputStream(targetFile);
            outChannel = fos.getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (Throwable throwable) {
            IoUtil.close(inChannel);
            IoUtil.close(outChannel);
            IoUtil.close(fis);
            IoUtil.close(fos);
            if (!targetFile.setLastModified(sourceFile.lastModified())) {
                throw new IOException("Last modified couldn't be set to " + targetFile + " from " + sourceFile);
            }
            throw throwable;
        }
        IoUtil.close(inChannel);
        IoUtil.close(outChannel);
        IoUtil.close(fis);
        IoUtil.close(fos);
        if (!targetFile.setLastModified(sourceFile.lastModified())) {
            throw new IOException("Last modified couldn't be set to " + targetFile + " from " + sourceFile);
        }
    }

    public static Stack<File> getPathFromRoot(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (file.getParent() == null) {
            return new Stack<File>();
        }
        Stack<File> path = new Stack<File>();
        File parent = file;
        while ((parent = path.push(parent).getParentFile()) != null) {
        }
        return path;
    }

    public static List<File> getSubDirectoriesRecursive(File directory, CancelRequest cancelRequest, DirectoryFilter.Option ... options) {
        File[] subDirs;
        boolean isCancel;
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        ArrayList<File> allSubDirs = new ArrayList<File>();
        boolean bl = isCancel = cancelRequest != null && cancelRequest.isCancel();
        if (isCancel) {
            return allSubDirs;
        }
        if (directory.isDirectory() && (subDirs = directory.listFiles(new DirectoryFilter(options))) != null) {
            for (File dir : subDirs) {
                boolean bl2 = isCancel = cancelRequest != null && cancelRequest.isCancel();
                if (isCancel) {
                    return Collections.emptyList();
                }
                allSubDirs.add(dir);
                List<File> subSubDirs = FileUtil.getSubDirectoriesRecursive(dir, cancelRequest, options);
                allSubDirs.addAll(subSubDirs);
            }
        }
        return allSubDirs;
    }

    public static List<String> getAbsolutePathnames(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        ArrayList<String> pathnames = new ArrayList<String>(files.size());
        for (File file : files) {
            pathnames.add(file.getAbsolutePath());
        }
        return pathnames;
    }

    public static List<File> getStringsAsFiles(Collection<? extends String> pathnames) {
        if (pathnames == null) {
            throw new NullPointerException("pathnames == null");
        }
        ArrayList<File> files = new ArrayList<File>(pathnames.size());
        for (String string : pathnames) {
            files.add(new File(string));
        }
        return files;
    }

    public static List<File> filterFiles(Collection<? extends File> files, FileFilter filter) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        ArrayList<File> filteredFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!filter.accept(file)) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    public static void deleteDirectoryRecursive(File directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    FileUtil.deleteDirectoryRecursive(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("File couldn't be deleted: " + file);
            }
        }
        if (!directory.delete()) {
            throw new IOException("Directory couldn't be deleted: " + directory);
        }
    }

    public static File getNotExistingFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        File newFile = file;
        int index = 0;
        while (newFile.exists()) {
            String pathname = file.getPath();
            int suffixPos = pathname.lastIndexOf(46);
            if (suffixPos > 0) {
                String suffix = pathname.substring(suffixPos + 1);
                String prefix = pathname.substring(0, suffixPos);
                pathname = prefix + "_" + Integer.valueOf(index) + "." + suffix;
            } else {
                pathname = pathname + "_" + Integer.valueOf(index);
            }
            ++index;
            newFile = new File(pathname);
        }
        return newFile;
    }

    public static File getRoot(File file) {
        File root;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        File parent = root = file.getParentFile();
        while (parent != null) {
            if (parent == null) continue;
            root = parent;
            parent = parent.getParentFile();
        }
        return root == null ? file : root;
    }

    public static String getDirectoryPath(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        String parent = file.getParent();
        if (parent == null) {
            return "";
        }
        String root = FileUtil.getRoot(file).getAbsolutePath();
        if (parent.startsWith(root) && parent.length() > root.length()) {
            return parent.substring(root.length());
        }
        return "";
    }

    public static String getSuffix(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        String pathname = file.getName();
        if (FileUtil.hasSuffix(pathname)) {
            return pathname.substring(pathname.lastIndexOf(46) + 1);
        }
        return "";
    }

    private static boolean hasSuffix(String pathname) {
        int index = pathname.lastIndexOf(46);
        int len = pathname.length();
        return index > 0 && index < len - 1;
    }

    public static Map<String, List<File>> getFilesWithSuffixIgnoreCase(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        HashMap<String, List<File>> filesOfSuffix = new HashMap<String, List<File>>();
        for (File file : files) {
            String suffixLowerCase = FileUtil.getSuffix(file).toLowerCase();
            LinkedList<File> fos = (LinkedList<File>)filesOfSuffix.get(suffixLowerCase);
            if (fos == null) {
                fos = new LinkedList<File>();
                filesOfSuffix.put(suffixLowerCase, fos);
            }
            fos.add(file);
        }
        return filesOfSuffix;
    }

    public static String getPrefix(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        int len = filename.length();
        if (index == 0 || index == len - 1) {
            return filename;
        }
        return filename.substring(0, filename.lastIndexOf(46));
    }

    public static String getAbsolutePathnamePrefix(String absolutePath) {
        if (absolutePath == null) {
            throw new NullPointerException("absolutePath == null");
        }
        int index = absolutePath.lastIndexOf(46);
        return index > 0 ? absolutePath.substring(0, index) : absolutePath;
    }

    public static List<File> getFilesWithEqualBasenames(Collection<File> files, String excludeSuffix) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (excludeSuffix == null) {
            throw new NullPointerException("excludeSuffix == null");
        }
        HashMap<String, ArrayList<File>> filesWithEqualPrefix = new HashMap<String, ArrayList<File>>();
        String excludeSuffixLowercase = excludeSuffix.toLowerCase();
        for (File file : files) {
            String filePathLowercase = file.getAbsolutePath();
            if (!excludeSuffixLowercase.isEmpty() && filePathLowercase.endsWith(excludeSuffixLowercase)) continue;
            String absolutePath = file.getAbsolutePath();
            String filePathPrefix = FileUtil.getAbsolutePathnamePrefix(absolutePath);
            String filePathPrefixLowercase = filePathPrefix.toLowerCase();
            ArrayList<File> fWithEqualPrefix = (ArrayList<File>)filesWithEqualPrefix.get(filePathPrefixLowercase);
            if (fWithEqualPrefix == null) {
                fWithEqualPrefix = new ArrayList<File>(3);
                filesWithEqualPrefix.put(filePathPrefixLowercase, fWithEqualPrefix);
            }
            fWithEqualPrefix.add(file);
        }
        ArrayList<File> filesWithEqualBasenames = new ArrayList<File>();
        for (List fWithEqualBasenames : filesWithEqualPrefix.values()) {
            int size = fWithEqualBasenames.size();
            if (size <= 1) continue;
            for (File filepath : fWithEqualBasenames) {
                filesWithEqualBasenames.add(filepath);
            }
        }
        return filesWithEqualBasenames;
    }

    public static File ensureSuffix(File file, String suffix) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix == null");
        }
        if (file.getName().toLowerCase().endsWith(suffix.toLowerCase())) {
            return file;
        }
        return new File(file.getPath() + suffix);
    }

    public static void touch(File fileToTouch, File referenceFile) {
        if (fileToTouch == null) {
            throw new NullPointerException("fileToTouch == null");
        }
        long reference = referenceFile == null ? System.currentTimeMillis() : referenceFile.lastModified();
        fileToTouch.setLastModified(reference);
    }

    public static String getMd5FilenameOfAbsolutePath(File file) {
        MessageDigest md5;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Throwable t) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
        md5.reset();
        md5.update(("file://" + file.getAbsolutePath()).getBytes());
        byte[] result = md5.digest();
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < result.length; ++i) {
            if ((result[i] & 0xFF) == 0) {
                hex.append("00");
                continue;
            }
            if ((result[i] & 0xFF) < 16) {
                hex.append("0").append(Integer.toHexString(0xFF & result[i]));
                continue;
            }
            hex.append(Integer.toHexString(0xFF & result[i]));
        }
        return hex.toString();
    }

    public static String getMd5OfFileContent(File file) throws IOException, NoSuchAlgorithmException {
        String string;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (!file.exists()) {
            throw new IllegalStateException("File does not exist: " + file);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = Md5Util.getMd5FromStream(is);
        }
        catch (FileNotFoundException ex) {
            try {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtil.close(is);
                throw throwable;
            }
        }
        IoUtil.close(is);
        return string;
    }

    public static String toStringWithMaximumLength(File file, int maximumLength) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Negative maximum length: " + maximumLength);
        }
        if (maximumLength == 0) {
            return "";
        }
        String filepath = file.getAbsolutePath();
        if (filepath.length() <= maximumLength) {
            return filepath;
        }
        String fill = "...";
        if (maximumLength <= fill.length()) {
            return StringUtil.getNTimesRepeated(".", maximumLength);
        }
        String filename = file.getName();
        StringBuilder sb = new StringBuilder();
        int filenameWithFillLength = fill.length() + File.separator.length() + filename.length();
        if (maximumLength >= filenameWithFillLength) {
            String filepathRemainder = filepath.substring(0, maximumLength - filenameWithFillLength);
            sb.append(filepathRemainder).append(fill).append(File.separator).append(filename);
        } else {
            String filenameRemainder = filename.substring(filename.length() - maximumLength + fill.length());
            sb.append(fill).append(filenameRemainder);
        }
        return sb.toString();
    }

    public static File getJarDirectory(Class<?> classWithinJar) {
        if (classWithinJar == null) {
            throw new NullPointerException("classWithinJar == null");
        }
        try {
            ProtectionDomain protectionDomain = classWithinJar.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL locationURL = codeSource.getLocation();
            URI locationURI = locationURL.toURI();
            File jarPath = new File(locationURI);
            File parentFile = jarPath.getParentFile();
            if (parentFile != null && parentFile.isDirectory()) {
                return parentFile;
            }
        }
        catch (Throwable t) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return null;
    }

    public static boolean inSameDirectory(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (files.isEmpty()) {
            return true;
        }
        File prevParent = CollectionUtil.getFirstElement(files).getParentFile();
        for (File file : files) {
            File parent = file.getParentFile();
            if (!ObjectUtil.equals(parent, prevParent)) {
                return false;
            }
            prevParent = parent;
        }
        return true;
    }

    public static List<File> listFiles(File parentFile, FileFilter filter) {
        if (parentFile == null) {
            throw new NullPointerException("parentFile == null");
        }
        File[] files = filter == null ? parentFile.listFiles() : parentFile.listFiles(filter);
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isReadableDirectory(File file) {
        return file != null && file.isDirectory() && file.canRead() && file.listFiles() != null;
    }

    public static boolean containsReadableDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!FileUtil.isReadableDirectory(file)) continue;
            return true;
        }
        return false;
    }

    private FileUtil() {
    }
}

