/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileLock {
    public static final FileLock INSTANCE = new FileLock();
    private static final Logger LOGGER = Logger.getLogger(FileLock.class.getName());
    private final Map<File, Object> ownerOfLockedFile = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(File file, Object owner) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (owner == null) {
            throw new NullPointerException("owner == null");
        }
        Map<File, Object> map = this.ownerOfLockedFile;
        synchronized (map) {
            if (!this.ownerOfLockedFile.containsKey(file)) {
                this.ownerOfLockedFile.put(file, owner);
                return true;
            }
            return false;
        }
    }

    public boolean lockLogWarning(File file, Object newOwner) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (newOwner == null) {
            throw new NullPointerException("owner == null");
        }
        if (!this.lock(file, newOwner)) {
            Object currentOwner = this.getOwner(file);
            LOGGER.log(Level.WARNING, "The file ''{0}'' couldn''t be locked through {1}, because it''s already locked through {2}!", new Object[]{file, newOwner, currentOwner});
            return false;
        }
        return true;
    }

    public Object getOwner(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return this.ownerOfLockedFile.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(File file, Object owner) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (owner == null) {
            throw new NullPointerException("owner == null");
        }
        Map<File, Object> map = this.ownerOfLockedFile;
        synchronized (map) {
            if (this.ownerOfLockedFile.containsKey(file) && this.ownerOfLockedFile.get(file).equals(owner)) {
                this.ownerOfLockedFile.remove(file);
                return true;
            }
            return false;
        }
    }

    private FileLock() {
    }
}

