/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.jphototagger.api.concurrent.CancelRequest;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.lib.io.DeleteOutOfDateFiles;

public final class DeleteOutOfDateFilesInDirectoryThread
extends Thread
implements Cancelable {
    private final File directory;
    private final FileFilter fileFilter;
    private final long deleteIfNMillisecondsOlderThanNow;
    private volatile boolean cancel;
    private final CancelRequest cancelRequest = new CancelRequest(){

        public boolean isCancel() {
            return DeleteOutOfDateFilesInDirectoryThread.this.cancel;
        }
    };

    public DeleteOutOfDateFilesInDirectoryThread(File directory, FileFilter fileFilter, long deleteIfNMillisecondsOlderThanNow) {
        super("JPhotoTagger: Deleting out of date files");
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directory);
        }
        if (fileFilter == null) {
            throw new NullPointerException("fileFilter == null");
        }
        this.directory = directory;
        this.fileFilter = fileFilter;
        this.deleteIfNMillisecondsOlderThanNow = deleteIfNMillisecondsOlderThanNow;
    }

    @Override
    public void run() {
        List<File> files = Arrays.asList(this.directory.listFiles(this.fileFilter));
        DeleteOutOfDateFiles deleteOutOfDateFiles = new DeleteOutOfDateFiles(files, this.deleteIfNMillisecondsOlderThanNow);
        deleteOutOfDateFiles.start(this.cancelRequest);
    }

    public void cancel() {
        this.cancel = true;
    }
}

