/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.CancelRequest;

public final class DeleteOutOfDateFiles {
    private final long deleteIfNMillisecondsOlderThanNow;
    private final Collection<? extends File> files;
    private static final Logger LOGGER = Logger.getLogger(DeleteOutOfDateFiles.class.getName());

    public DeleteOutOfDateFiles(Collection<? extends File> files, long deleteIfNMillisecondsOlderThanNow) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (deleteIfNMillisecondsOlderThanNow < 0L) {
            throw new IllegalArgumentException("Negative millisecond difference: " + deleteIfNMillisecondsOlderThanNow);
        }
        this.files = new ArrayList<File>(files);
        this.deleteIfNMillisecondsOlderThanNow = deleteIfNMillisecondsOlderThanNow;
    }

    public int start(CancelRequest cancelRequest) {
        int countDeleted = 0;
        for (File file : this.files) {
            long nowInMilliseconds;
            long minMilliseconds;
            if (!file.exists()) continue;
            if (cancelRequest != null && cancelRequest.isCancel()) {
                return countDeleted;
            }
            long lastModifiedInMilliseconds = file.lastModified();
            boolean isTooOld = lastModifiedInMilliseconds < (minMilliseconds = (nowInMilliseconds = System.currentTimeMillis()) - this.deleteIfNMillisecondsOlderThanNow);
            if (!isTooOld) continue;
            LOGGER.log(Level.FINEST, "Deleting file ''{0}'' because it is older than {1} milliseconds", new Object[]{file, this.deleteIfNMillisecondsOlderThanNow});
            boolean deleted = file.delete();
            if (deleted) {
                ++countDeleted;
                continue;
            }
            LOGGER.log(Level.WARNING, "Could not delete file ''{0}''", file);
        }
        LOGGER.log(Level.FINEST, "Deleted {0} files", countDeleted);
        return countDeleted;
    }
}

