/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.help;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public final class TextHighlighter {
    private final Highlighter highlighter = new DefaultHighlighter();
    private Highlighter.HighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private final JTextComponent tc;
    private final Set<String> hlWords = new HashSet<String>();
    private boolean inWord;
    private int wordStartIndex = -1;

    TextHighlighter(JTextComponent tc) {
        if (tc == null) {
            throw new NullPointerException("tc == null");
        }
        this.tc = tc;
        tc.setHighlighter(this.highlighter);
    }

    synchronized void setHighlightColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color == null");
        }
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(color);
    }

    synchronized void highlightWords(Set<String> words) {
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        this.hlWords.clear();
        this.addAsLowercase(words);
        this.highlight();
    }

    private synchronized void addAsLowercase(Set<String> wds) {
        for (String word : wds) {
            this.hlWords.add(word.toLowerCase());
        }
    }

    synchronized void removeAllHighlights() {
        this.highlighter.removeAllHighlights();
    }

    private synchronized void highlight() {
        int offset = 0;
        this.highlighter.removeAllHighlights();
        this.wordStartIndex = -1;
        Segment segment = new Segment();
        Document document = this.tc.getDocument();
        try {
            int documentLength = document.getLength();
            document.getText(0, documentLength > 0 ? documentLength - 1 : 0, segment);
        }
        catch (Throwable t) {
            Logger.getLogger(TextHighlighter.class.getName()).log(Level.SEVERE, null, t);
        }
        String text = segment.toString();
        int len = text.length();
        String currentWord = "";
        for (int i = offset; i < len; ++i) {
            this.inWord = Character.isLetterOrDigit(text.charAt(i));
            if (this.inWord && this.wordStartIndex == -1) {
                this.wordStartIndex = i;
            } else if (!this.inWord) {
                this.wordStartIndex = -1;
            }
            if (!this.inWord) continue;
            currentWord = text.substring(this.wordStartIndex, i + 1);
            if (!this.hlWords.contains(currentWord = currentWord.toLowerCase())) continue;
            try {
                this.highlighter.addHighlight(this.wordStartIndex, i + 1, this.painter);
                continue;
            }
            catch (Throwable t) {
                Logger.getLogger(TextHighlighter.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }
}

