/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.help;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.help.HelpContentProvider;
import org.jphototagger.lib.help.HelpDisplayer;
import org.jphototagger.lib.help.HelpIndexParser;
import org.jphototagger.lib.help.HelpNode;
import org.jphototagger.lib.help.HelpPage;
import org.openide.util.Lookup;

public final class HelpUtil {
    public static void showHelp(String url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        HelpDisplayer helpDisplay = (HelpDisplayer)Lookup.getDefault().lookup(HelpDisplayer.class);
        if (helpDisplay != null) {
            helpDisplay.displayHelp(url);
        }
    }

    public static HelpNode createNodeFromHelpContentProviders() {
        HelpNode rootNode = null;
        ArrayList providers = new ArrayList(Lookup.getDefault().lookupAll(HelpContentProvider.class));
        Collections.sort(providers, PositionProviderAscendingComparator.INSTANCE);
        for (HelpContentProvider provider : providers) {
            String helpContentsUrl = provider.getHelpContentUrl();
            HelpIndexParser helpIndexParser = new HelpIndexParser(helpContentsUrl);
            HelpNode helpNode = helpIndexParser.parse(HelpUtil.class.getResourceAsStream(helpContentsUrl));
            if (rootNode == null) {
                rootNode = helpNode;
                continue;
            }
            HelpUtil.addChildrenToNode(helpNode, rootNode);
        }
        return rootNode;
    }

    private static void addChildrenToNode(HelpNode fromHelpNode, HelpNode toHelpNode) {
        int childCount = fromHelpNode.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            Object child = fromHelpNode.getChild(index);
            if (child instanceof HelpNode) {
                HelpNode helpNode = (HelpNode)child;
                toHelpNode.addNode(helpNode);
                continue;
            }
            if (!(child instanceof HelpPage)) continue;
            HelpPage helpPage = (HelpPage)child;
            toHelpNode.addPage(helpPage);
        }
    }

    public static Collection<HelpPage> findHelpPagesRecursive(HelpNode helpNode) {
        if (helpNode == null) {
            throw new NullPointerException("helpNode == null");
        }
        LinkedList<HelpPage> helpPages = new LinkedList<HelpPage>();
        HelpUtil.addHelpPagesRecursive(helpNode, helpPages);
        return helpPages;
    }

    private static void addHelpPagesRecursive(HelpNode helpNode, Collection<HelpPage> helpPages) {
        int childCount = helpNode.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            Object child = helpNode.getChild(childIndex);
            if (child instanceof HelpNode) {
                HelpUtil.addHelpPagesRecursive((HelpNode)child, helpPages);
            }
            if (!(child instanceof HelpPage)) continue;
            HelpPage helpPage = (HelpPage)child;
            helpPages.add(helpPage);
        }
    }

    private HelpUtil() {
    }
}

