/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jphototagger.lib.help.HelpPage;
import org.jphototagger.lib.util.ObjectUtil;

public final class HelpNode {
    private String title;
    private final List<Object> children = new ArrayList<Object>();
    private HelpNode parent;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title == null");
        }
        this.title = title;
    }

    public void addPage(HelpPage page) {
        if (page == null) {
            throw new NullPointerException("page == null");
        }
        page.setParent(this);
        this.children.add(page);
    }

    public void addNode(HelpNode chapter) {
        if (chapter == null) {
            throw new NullPointerException("chapter == null");
        }
        HelpNode equalChapter = this.findEqualChildNode(chapter);
        if (equalChapter == null) {
            chapter.parent = this;
            this.children.add(chapter);
        } else {
            equalChapter.children.addAll(chapter.children);
        }
    }

    private HelpNode findEqualChildNode(HelpNode helpNode) {
        for (Object child : this.children) {
            HelpNode childHelpNode;
            if (!(child instanceof HelpNode) || !(childHelpNode = (HelpNode)child).equals(helpNode)) continue;
            return childHelpNode;
        }
        return null;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Object getChild(int index) {
        int count = this.children.size();
        if (index < 0 || index >= count) {
            throw new IndexOutOfBoundsException("invalid index" + index + ", size: " + count);
        }
        return this.children.get(index);
    }

    public int getIndexOfChild(Object child) {
        if (child == null) {
            throw new NullPointerException("child == null");
        }
        return this.children.indexOf(child);
    }

    public HelpNode getParent() {
        return this.parent;
    }

    public Object[] getPagePath(String url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        ArrayList<Object> found = new ArrayList<Object>();
        this.findPath(url, found);
        return found.size() > 0 ? found.toArray() : null;
    }

    private void findPath(String url, List<Object> found) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        if (found == null) {
            throw new NullPointerException("found == null");
        }
        int size = this.children.size();
        for (int i = 0; found.size() <= 0 && i < size; ++i) {
            Object child = this.children.get(i);
            if (child instanceof HelpPage) {
                HelpPage helpPage = (HelpPage)child;
                if (!helpPage.getUrl().equals(url)) continue;
                found.addAll(this.getPagePath(helpPage));
                continue;
            }
            if (!(child instanceof HelpNode)) continue;
            ((HelpNode)child).findPath(url, found);
        }
    }

    private Stack<Object> getPagePath(HelpPage helpPage) {
        if (helpPage == null) {
            throw new NullPointerException("helpPage == null");
        }
        Stack<Object> path = new Stack<Object>();
        path.push(helpPage);
        HelpNode p = helpPage.getParent();
        while (p != null) {
            path.push(p);
            p = p.parent;
        }
        Collections.reverse(path);
        return path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HelpNode)) {
            return false;
        }
        HelpNode other = (HelpNode)obj;
        return ObjectUtil.equals(this.title, other.title);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.title != null ? this.title.hashCode() : 0);
        return hash;
    }
}

