/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.help;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jphototagger.lib.help.HelpNode;
import org.jphototagger.lib.help.HelpPage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class HelpIndexParser {
    private final String contentsUrl;
    private final String contentsUrlPath;

    public HelpIndexParser(String contentsUrl) {
        if (contentsUrl == null) {
            throw new NullPointerException("contentsUrl == null");
        }
        this.contentsUrl = contentsUrl;
        int lastIndex = contentsUrl.lastIndexOf(47);
        this.contentsUrlPath = lastIndex > 0 ? contentsUrl.substring(0, lastIndex) : "";
    }

    public HelpNode parse(InputStream is) {
        if (is == null) {
            throw new NullPointerException("is == null");
        }
        HelpNode rootNode = null;
        try {
            DocumentBuilderFactory factory = this.getDocBuilderFactory();
            DocumentBuilder docBuilder = this.getDocBuilder(factory);
            Document document = docBuilder.parse(is);
            document.getDocumentElement().normalize();
            rootNode = this.getTree(document);
        }
        catch (Throwable t) {
            Logger.getLogger(HelpIndexParser.class.getName()).log(Level.SEVERE, null, t);
        }
        return rootNode;
    }

    private HelpNode getTree(Document document) throws DOMException {
        HelpNode rootNode = new HelpNode();
        NodeList docNodes = document.getElementsByTagName("helpindex").item(0).getChildNodes();
        int length = docNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = docNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("node")) {
                this.parseNode((Element)node, rootNode);
                continue;
            }
            if (!nodeName.equals("page")) continue;
            rootNode.addPage(this.getPage((Element)node));
        }
        return rootNode;
    }

    private void parseNode(Element section, HelpNode rootNode) {
        HelpNode helpNode = new HelpNode();
        NodeList title = section.getElementsByTagName("title");
        helpNode.setTitle(title.item(0).getFirstChild().getNodeValue().trim());
        NodeList nodes = section.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            if (nodes.item(i).getNodeName().equals("section")) {
                this.parseNode((Element)nodes.item(i), rootNode);
                continue;
            }
            if (!nodes.item(i).getNodeName().equals("page")) continue;
            helpNode.addPage(this.getPage((Element)nodes.item(i)));
        }
        rootNode.addNode(helpNode);
    }

    private HelpPage getPage(Element page) throws DOMException {
        HelpPage helpPage = new HelpPage();
        NodeList url = page.getElementsByTagName("url");
        NodeList title = page.getElementsByTagName("title");
        String urlString = url.item(0).getFirstChild().getNodeValue().trim();
        if (!urlString.startsWith(this.contentsUrlPath)) {
            urlString = this.contentsUrlPath + '/' + urlString;
        }
        helpPage.setUrl(urlString);
        helpPage.setTitle(title.item(0).getFirstChild().getNodeValue().trim());
        return helpPage;
    }

    private DocumentBuilderFactory getDocBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", true);
        return factory;
    }

    private DocumentBuilder getDocBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        this.setEntityResolver(documentBuilder);
        this.setErrorHandler(documentBuilder);
        return documentBuilder;
    }

    private void setEntityResolver(DocumentBuilder documentBuilder) {
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputStream is = HelpIndexParser.class.getResourceAsStream("/org/jphototagger/lib/help/helpindex.dtd");
                InputSource ip = new InputSource(is);
                ip.setSystemId("helpindex.dtd");
                return ip;
            }
        });
    }

    private void setErrorHandler(DocumentBuilder documentBuilder) {
        documentBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
    }
}

