/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.help;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTextField;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.help.HelpBrowserEvent;
import org.jphototagger.lib.help.HelpBrowserListener;
import org.jphototagger.lib.help.HelpContentsTreeModel;
import org.jphototagger.lib.help.HelpNode;
import org.jphototagger.lib.help.HelpPage;
import org.jphototagger.lib.help.HelpSearch;
import org.jphototagger.lib.help.HelpUtil;
import org.jphototagger.lib.help.TextHighlighter;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swingx.SearchInComponentAction;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public final class HelpBrowser
extends Dialog
implements HyperlinkListener,
TreeSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DIVIDER_LOCATION = "HelpBrowser.DividerLocation";
    private static final String KEY_TEXT_FONT_SIZE = "HelpBrowser.TextFontSize";
    private final LinkedList<URL> urlHistory = new LinkedList();
    private int currentHistoryIndex = -1;
    private final Set<HelpBrowserListener> listeners = new CopyOnWriteArraySet<HelpBrowserListener>();
    private final GoToNextUrlAction goToNextUrlAction = new GoToNextUrlAction();
    private final GoToPreviousUrlAction goToPreviousUrlAction = new GoToPreviousUrlAction();
    private String displayUrl;
    private boolean settingPath;
    private final HelpNode rootNode;
    private final Collection<HelpPage> helpPages;
    private final HelpSearch helpSearch;
    private String titlePostfix = Bundle.getString(HelpBrowser.class, "HelpBrowser.TitlePostfix", new Object[0]);
    private HelpPage selectedFoundPage;
    private final Map<JMenuItem, Integer> textFontSizeOfMenuItem = new HashMap<JMenuItem, Integer>();
    private final ObservableList<HelpPage> foundPages = ObservableCollections.observableList(new ArrayList());
    private volatile boolean isHighlight;
    private final TextHighlighter textHighLighter;
    private JButton buttonGotoNextUrl;
    private JButton buttonGotoPreviousUrl;
    private ButtonGroup buttonGroupTextSize;
    private JButton buttonPrint;
    private JButton buttonSearchInCurrentPage;
    private JXEditorPane editorPanePage;
    private JMenuBar jMenuBar1;
    private JLabel labelSearch;
    private JXList listSearchResults;
    private JMenuItem menuItemGotNextUrl;
    private JMenuItem menuItemGotoPreviousUrl;
    private JRadioButtonMenuItem menuItemTextFontSizeHuge;
    private JRadioButtonMenuItem menuItemTextFontSizeLarge;
    private JRadioButtonMenuItem menuItemTextFontSizeNormal;
    private JRadioButtonMenuItem menuItemTextFontSizeSmall;
    private JMenu menuView;
    private JPanel panelButtons;
    private JPanel panelContents;
    private JPanel panelPage;
    private JPanel panelSearch;
    private JPopupMenu popupMenuEditorPane;
    private JScrollPane scrollPanePage;
    private JScrollPane scrollPaneSearchResults;
    private JScrollPane scrollPaneTree;
    private JSplitPane splitPane;
    private JTabbedPane tabbedPaneContents;
    private JXTextField textFieldSearch;
    private JTree tree;
    private BindingGroup bindingGroup;

    public HelpBrowser(HelpNode rootNode) {
        super(ComponentUtil.findFrameWithIcon());
        if (rootNode == null) {
            throw new NullPointerException("rootNode == null");
        }
        this.rootNode = rootNode;
        this.helpSearch = new HelpSearch(rootNode);
        this.helpPages = new LinkedHashSet<HelpPage>(HelpUtil.findHelpPagesRecursive(rootNode));
        this.initComponents();
        this.postInitComponents();
        this.tree.setModel(new HelpContentsTreeModel(rootNode));
        this.textHighLighter = new TextHighlighter((JTextComponent)this.editorPanePage);
    }

    private void postInitComponents() {
        this.editorPanePage.addHyperlinkListener((HyperlinkListener)this);
        this.editorPanePage.addPropertyChangeListener((PropertyChangeListener)this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        MnemonicUtil.setMnemonics(this);
        MnemonicUtil.setMnemonics(this.popupMenuEditorPane);
        this.addSearchAction();
        this.initPreviousNextShortcuts();
        this.initTextFontSizeOfMenuItem();
        AnnotationProcessor.process(this);
        new HeplpSearchInit().start();
    }

    private void initTextFontSizeOfMenuItem() {
        this.textFontSizeOfMenuItem.put(this.menuItemTextFontSizeSmall, 10);
        this.textFontSizeOfMenuItem.put(this.menuItemTextFontSizeNormal, 14);
        this.textFontSizeOfMenuItem.put(this.menuItemTextFontSizeLarge, 18);
        this.textFontSizeOfMenuItem.put(this.menuItemTextFontSizeHuge, 28);
    }

    private void initPreviousNextShortcuts() {
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(39, 512), "nexturl");
        actionMap.put("nexturl", this.goToNextUrlAction);
        inputMap.put(KeyStroke.getKeyStroke(37, 512), "prevurl");
        actionMap.put("prevurl", this.goToPreviousUrlAction);
    }

    public void addHelpBrowserListener(HelpBrowserListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.listeners.add(listener);
    }

    public void removeHelpBrowserListener(HelpBrowserListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.listeners.remove(listener);
    }

    private void notifyUrlChanged(URL url) {
        HelpBrowserEvent action = new HelpBrowserEvent(this, HelpBrowserEvent.Type.URL_CHANGED, url);
        for (HelpBrowserListener listener : this.listeners) {
            listener.actionPerformed(action);
        }
    }

    private void showUrl(URL url) {
        this.removeLastUrlFromUrlHistory();
        ++this.currentHistoryIndex;
        this.urlHistory.add(url);
        this.setGotActionsEnabled();
        this.setPage(url);
        this.notifyUrlChanged(url);
    }

    private void removeLastUrlFromUrlHistory() {
        boolean canRemove;
        int historyUrlCount = this.urlHistory.size();
        boolean bl = canRemove = historyUrlCount > 0 && this.currentHistoryIndex >= 0 && this.currentHistoryIndex < historyUrlCount;
        if (canRemove) {
            int removeCount = historyUrlCount - this.currentHistoryIndex - 1;
            for (int i = 0; i < removeCount; ++i) {
                this.urlHistory.pollLast();
            }
        }
    }

    public synchronized void setDisplayUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        this.displayUrl = url;
    }

    private synchronized void selectDisplayUrl() {
        HelpNode node;
        Object[] path;
        if (this.displayUrl != null && (path = (node = (HelpNode)this.tree.getModel().getRoot()).getPagePath(this.displayUrl)) != null) {
            this.tree.setSelectionPath(new TreePath(path));
        }
    }

    private void setPage(URL url) {
        try {
            this.textHighLighter.removeAllHighlights();
            this.editorPanePage.setPage(url);
        }
        catch (Throwable t) {
            Logger.getLogger(HelpBrowser.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.readDividerLocationFromPreferences();
            this.restoreTextFontSize();
            this.selectDisplayUrl();
        } else {
            this.writeDividerLocationToPreferences();
        }
        super.setVisible(visible);
    }

    private void readDividerLocationFromPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null && prefs.containsKey(KEY_DIVIDER_LOCATION)) {
            this.splitPane.setDividerLocation(prefs.getInt(KEY_DIVIDER_LOCATION));
        }
    }

    private void writeDividerLocationToPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.setInt(KEY_DIVIDER_LOCATION, this.splitPane.getDividerLocation());
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = evt.getURL();
            String jptUrl = this.toPageUrl(url);
            Object[] path = this.rootNode.getPagePath(jptUrl);
            if (path == null) {
                this.showUrl(url);
            } else {
                this.tree.setSelectionPath(new TreePath(path));
            }
        }
    }

    public String toPageUrl(URL url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        String urlPath = url.getPath();
        if (!StringUtil.hasContent(urlPath)) {
            return "";
        }
        String foundPageUrl = null;
        for (HelpPage page : this.helpPages) {
            String pageUrl = page.getUrl();
            if (!pageUrl.equals(urlPath) && !urlPath.endsWith(pageUrl)) continue;
            foundPageUrl = pageUrl;
            break;
        }
        return foundPageUrl == null ? urlPath : foundPageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        HelpBrowser helpBrowser = this;
        synchronized (helpBrowser) {
            Object o;
            if (!this.settingPath && evt.isAddedPath() && (o = evt.getNewLeadSelectionPath().getLastPathComponent()) instanceof HelpPage) {
                HelpPage helpPage = (HelpPage)o;
                String helpPageUrl = helpPage.getUrl();
                URL url = this.getClass().getResource(helpPageUrl);
                super.setTitle(helpPage.getTitle() + " - " + this.titlePostfix);
                this.showUrl(url);
            }
        }
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title == null");
        }
        this.titlePostfix = title;
        super.setTitle(title);
    }

    private void setFontSizeOfHelpPageText(int textFontSize) {
        Font font = this.editorPanePage.getFont();
        int oldSize = font.getSize();
        if (textFontSize == oldSize) {
            return;
        }
        String fontName = font.getName();
        Font newFont = new Font(fontName, 0, textFontSize);
        this.editorPanePage.setFont(newFont);
        this.persisteTextFontSize(textFontSize);
        ComponentUtil.forceRepaint(this.panelContents);
    }

    private void setTextFontSizeOfMenuItem(JMenuItem menuItem) {
        Integer textFontSize = this.textFontSizeOfMenuItem.get(menuItem);
        if (textFontSize != null) {
            this.setFontSizeOfHelpPageText(textFontSize);
        }
    }

    private void persisteTextFontSize(int textFontSize) {
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        preferences.setInt(KEY_TEXT_FONT_SIZE, textFontSize);
    }

    private void restoreTextFontSize() {
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (preferences != null && preferences.containsKey(KEY_TEXT_FONT_SIZE)) {
            int textFontSize = preferences.getInt(KEY_TEXT_FONT_SIZE);
            for (JMenuItem menuItem : this.textFontSizeOfMenuItem.keySet()) {
                int fontSizeOfMenuItem = this.textFontSizeOfMenuItem.get(menuItem);
                if (fontSizeOfMenuItem != textFontSize) continue;
                menuItem.setSelected(true);
                this.setFontSizeOfHelpPageText(textFontSize);
                break;
            }
        }
    }

    private void setGotActionsEnabled() {
        this.goToNextUrlAction.setEnabled(this.canGoToNextUrl());
        this.goToPreviousUrlAction.setEnabled(this.canGoToPreviousUrl());
    }

    private boolean canGoToNextUrl() {
        return this.currentHistoryIndex + 1 > 0 && this.currentHistoryIndex + 1 < this.urlHistory.size();
    }

    private boolean canGoToPreviousUrl() {
        return this.currentHistoryIndex - 1 >= 0 && this.currentHistoryIndex - 1 < this.urlHistory.size();
    }

    private void setSelectionPath(String lastPathComponent) {
        Object[] path = this.rootNode.getPagePath(lastPathComponent);
        if (path != null) {
            this.settingPath = true;
            this.tree.setSelectionPath(new TreePath(path));
            this.settingPath = false;
        }
    }

    public HelpPage getSelectedFoundPage() {
        return this.selectedFoundPage;
    }

    public void setSelectedFoundPage(HelpPage selectedFoundPage) {
        this.selectedFoundPage = selectedFoundPage;
        if (selectedFoundPage != null) {
            this.setDisplayUrl(selectedFoundPage.getUrl());
            this.isHighlight = true;
            this.selectDisplayUrl();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("page".equals(evt.getPropertyName()) && this.isHighlight) {
            this.isHighlight = false;
            this.highLightSearchTerms();
        }
    }

    private void highLightSearchTerms() {
        String text = this.textFieldSearch.getText();
        String[] searchTerms = text.split(" ");
        List<String> searchTermsWithContent = StringUtil.getStringsWithContent(searchTerms);
        if (!searchTermsWithContent.isEmpty()) {
            this.textHighLighter.highlightWords(new HashSet<String>(searchTermsWithContent));
            ComponentUtil.forceRepaint((Component)this.editorPanePage);
        }
    }

    public ObservableList<HelpPage> getFoundPages() {
        return this.foundPages;
    }

    private void search() {
        String searchText = this.textFieldSearch.getText();
        this.foundPages.clear();
        if (StringUtil.hasContent(searchText)) {
            List<HelpPage> foundHelpPages = this.helpSearch.findHelpPagesMatching(searchText);
            this.foundPages.addAll(foundHelpPages);
        }
    }

    private void addSearchAction() {
        String name = Bundle.getString(HelpBrowser.class, "HelpBrowser.SearchInComponentAction.Name", new Object[0]);
        String tooltipText = Bundle.getString(HelpBrowser.class, "HelpBrowser.SearchInComponentAction.TooltipText", new Object[0]);
        SearchInComponentAction searchInComponentAction = new SearchInComponentAction((JComponent)this.editorPanePage, name);
        this.buttonSearchInCurrentPage.setAction(searchInComponentAction);
        this.buttonSearchInCurrentPage.setToolTipText(tooltipText);
        MnemonicUtil.setMnemonics(this.buttonSearchInCurrentPage);
    }

    private void printPage() {
        try {
            this.editorPanePage.print();
        }
        catch (Throwable t) {
            Logger.getLogger(HelpBrowser.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.popupMenuEditorPane = new JPopupMenu();
        this.menuItemGotNextUrl = new JMenuItem();
        this.menuItemGotoPreviousUrl = new JMenuItem();
        this.buttonGroupTextSize = new ButtonGroup();
        this.splitPane = new JSplitPane();
        this.tabbedPaneContents = new JTabbedPane();
        this.panelContents = new JPanel();
        this.scrollPaneTree = new JScrollPane();
        this.tree = new JTree();
        this.panelSearch = new JPanel();
        this.labelSearch = new JLabel();
        this.textFieldSearch = new JXTextField();
        this.scrollPaneSearchResults = new JScrollPane();
        this.listSearchResults = new JXList();
        this.panelPage = new JPanel();
        this.scrollPanePage = new JScrollPane();
        this.editorPanePage = new JXEditorPane();
        this.panelButtons = new JPanel();
        this.buttonPrint = new JButton();
        this.buttonSearchInCurrentPage = new JButton();
        this.buttonGotoPreviousUrl = new JButton();
        this.buttonGotoNextUrl = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.menuView = new JMenu();
        this.menuItemTextFontSizeSmall = new JRadioButtonMenuItem();
        this.menuItemTextFontSizeNormal = new JRadioButtonMenuItem();
        this.menuItemTextFontSizeLarge = new JRadioButtonMenuItem();
        this.menuItemTextFontSizeHuge = new JRadioButtonMenuItem();
        this.popupMenuEditorPane.setName("popupMenuEditorPane");
        this.menuItemGotNextUrl.setAction(this.goToNextUrlAction);
        this.menuItemGotNextUrl.setName("menuItemGotNextUrl");
        this.popupMenuEditorPane.add(this.menuItemGotNextUrl);
        this.menuItemGotoPreviousUrl.setAction(this.goToPreviousUrlAction);
        this.menuItemGotoPreviousUrl.setName("menuItemGotoPreviousUrl");
        this.popupMenuEditorPane.add(this.menuItemGotoPreviousUrl);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/help/Bundle");
        this.setTitle(bundle.getString("HelpBrowser.title"));
        this.setName("Form");
        this.splitPane.setDividerLocation(250);
        this.splitPane.setDividerSize(2);
        this.splitPane.setName("splitPane");
        this.tabbedPaneContents.setName("tabbedPaneContents");
        this.panelContents.setName("panelContents");
        this.panelContents.setLayout(new GridBagLayout());
        this.scrollPaneTree.setName("scrollPaneTree");
        this.scrollPaneTree.setPreferredSize(new Dimension(150, 10));
        this.tree.setModel(null);
        this.tree.setCellRenderer(new HelpContentsTreeCellRenderer());
        this.tree.setName("tree");
        this.scrollPaneTree.setViewportView(this.tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelContents.add((Component)this.scrollPaneTree, gridBagConstraints);
        this.tabbedPaneContents.addTab(bundle.getString("HelpBrowser.panelContents.TabConstraints.tabTitle"), this.panelContents);
        this.panelSearch.setName("panelSearch");
        this.panelSearch.setLayout(new GridBagLayout());
        this.labelSearch.setLabelFor((Component)this.textFieldSearch);
        this.labelSearch.setText(bundle.getString("HelpBrowser.labelSearch.text"));
        this.labelSearch.setName("labelSearch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelSearch.add((Component)this.labelSearch, gridBagConstraints);
        this.textFieldSearch.setColumns(15);
        this.textFieldSearch.setName("textFieldSearch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelSearch.add((Component)this.textFieldSearch, gridBagConstraints);
        this.scrollPaneSearchResults.setName("scrollPaneSearchResults");
        this.listSearchResults.setSelectionMode(0);
        this.listSearchResults.setCellRenderer((ListCellRenderer)new HelpPageListCellRenderer());
        this.listSearchResults.setName("listSearchResults");
        ELProperty eLProperty = ELProperty.create("${foundPages}");
        JListBinding jListBinding = SwingBindings.createJListBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, eLProperty, (JList)this.listSearchResults);
        this.bindingGroup.addBinding(jListBinding);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${selectedFoundPage}"), this.listSearchResults, BeanProperty.create("selectedElement"));
        this.bindingGroup.addBinding(binding);
        this.scrollPaneSearchResults.setViewportView((Component)this.listSearchResults);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSearch.add((Component)this.scrollPaneSearchResults, gridBagConstraints);
        this.tabbedPaneContents.addTab(bundle.getString("HelpBrowser.panelSearch.TabConstraints.tabTitle"), this.panelSearch);
        this.splitPane.setLeftComponent(this.tabbedPaneContents);
        this.panelPage.setName("panelPage");
        this.panelPage.setLayout(new GridBagLayout());
        this.scrollPanePage.setName("scrollPanePage");
        this.scrollPanePage.setPreferredSize(new Dimension(200, 24));
        this.editorPanePage.setEditable(false);
        this.editorPanePage.setFont(new Font("Verdana", 0, 14));
        this.editorPanePage.setComponentPopupMenu(this.popupMenuEditorPane);
        this.editorPanePage.setName("editorPanePage");
        this.scrollPanePage.setViewportView((Component)this.editorPanePage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelPage.add((Component)this.scrollPanePage, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonPrint.setText(bundle.getString("HelpBrowser.buttonPrint.text"));
        this.buttonPrint.setToolTipText(bundle.getString("HelpBrowser.buttonPrint.toolTipText"));
        this.buttonPrint.setName("buttonPrint");
        this.buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpBrowser.this.buttonPrintActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonPrint);
        this.buttonSearchInCurrentPage.setToolTipText(bundle.getString("HelpBrowser.buttonSearchInCurrentPage.toolTipText"));
        this.buttonSearchInCurrentPage.setName("buttonSearchInCurrentPage");
        this.panelButtons.add(this.buttonSearchInCurrentPage);
        this.buttonGotoPreviousUrl.setAction(this.goToPreviousUrlAction);
        this.buttonGotoPreviousUrl.setName("buttonGotoPreviousUrl");
        this.panelButtons.add(this.buttonGotoPreviousUrl);
        this.buttonGotoNextUrl.setAction(this.goToNextUrlAction);
        this.buttonGotoNextUrl.setName("buttonGotoNextUrl");
        this.panelButtons.add(this.buttonGotoNextUrl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPage.add((Component)this.panelButtons, gridBagConstraints);
        this.splitPane.setRightComponent(this.panelPage);
        this.jMenuBar1.setName("jMenuBar1");
        this.menuView.setText(bundle.getString("HelpBrowser.menuView.text"));
        this.menuView.setName("menuView");
        this.buttonGroupTextSize.add(this.menuItemTextFontSizeSmall);
        this.menuItemTextFontSizeSmall.setText(bundle.getString("HelpBrowser.menuItemTextFontSizeSmall.text"));
        this.menuItemTextFontSizeSmall.setName("menuItemTextFontSizeSmall");
        this.menuItemTextFontSizeSmall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpBrowser.this.menuItemTextFontSizeSmallActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuItemTextFontSizeSmall);
        this.buttonGroupTextSize.add(this.menuItemTextFontSizeNormal);
        this.menuItemTextFontSizeNormal.setSelected(true);
        this.menuItemTextFontSizeNormal.setText(bundle.getString("HelpBrowser.menuItemTextFontSizeNormal.text"));
        this.menuItemTextFontSizeNormal.setName("menuItemTextFontSizeNormal");
        this.menuItemTextFontSizeNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpBrowser.this.menuItemTextFontSizeNormalActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuItemTextFontSizeNormal);
        this.buttonGroupTextSize.add(this.menuItemTextFontSizeLarge);
        this.menuItemTextFontSizeLarge.setText(bundle.getString("HelpBrowser.menuItemTextFontSizeLarge.text"));
        this.menuItemTextFontSizeLarge.setName("menuItemTextFontSizeLarge");
        this.menuItemTextFontSizeLarge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpBrowser.this.menuItemTextFontSizeLargeActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuItemTextFontSizeLarge);
        this.buttonGroupTextSize.add(this.menuItemTextFontSizeHuge);
        this.menuItemTextFontSizeHuge.setText(bundle.getString("HelpBrowser.menuItemTextFontSizeHuge.text"));
        this.menuItemTextFontSizeHuge.setName("menuItemTextFontSizeHuge");
        this.menuItemTextFontSizeHuge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpBrowser.this.menuItemTextFontSizeHugeActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuItemTextFontSizeHuge);
        this.jMenuBar1.add(this.menuView);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane, -1, 570, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane, -1, 556, Short.MAX_VALUE).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void menuItemTextFontSizeSmallActionPerformed(ActionEvent evt) {
        this.setTextFontSizeOfMenuItem(this.menuItemTextFontSizeSmall);
    }

    private void menuItemTextFontSizeNormalActionPerformed(ActionEvent evt) {
        this.setTextFontSizeOfMenuItem(this.menuItemTextFontSizeNormal);
    }

    private void menuItemTextFontSizeLargeActionPerformed(ActionEvent evt) {
        this.setTextFontSizeOfMenuItem(this.menuItemTextFontSizeLarge);
    }

    private void menuItemTextFontSizeHugeActionPerformed(ActionEvent evt) {
        this.setTextFontSizeOfMenuItem(this.menuItemTextFontSizeHuge);
    }

    private void buttonPrintActionPerformed(ActionEvent evt) {
        this.printPage();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new HelpBrowser(new HelpNode()).setVisible(true);
            }
        });
    }

    private static class HelpPageListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final ImageIcon ICON = IconUtil.getImageIcon(HelpPageListCellRenderer.class, "help_page.png");

        private HelpPageListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon(ICON);
            return label;
        }
    }

    private static class HelpContentsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final ImageIcon ICON_SECTION_COLLAPSED = IconUtil.getImageIcon(HelpContentsTreeCellRenderer.class, "help_section_collapsed.png");
        private static final ImageIcon ICON_SECTION_EXPANDED = IconUtil.getImageIcon(HelpContentsTreeCellRenderer.class, "help_section_expanded.png");
        private static final ImageIcon ICON_PAGE = IconUtil.getImageIcon(HelpContentsTreeCellRenderer.class, "help_page.png");
        private static final long serialVersionUID = 1L;

        private HelpContentsTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, hasFocus);
            if (value instanceof HelpPage) {
                this.setIcon(ICON_PAGE);
                this.setText(((HelpPage)value).getTitle());
            } else if (value instanceof HelpNode) {
                this.setIcon(expanded ? ICON_SECTION_EXPANDED : ICON_SECTION_COLLAPSED);
                this.setText(((HelpNode)value).getTitle());
            } else if (value == tree.getModel().getRoot()) {
                this.setIcon(null);
                this.setText("");
            }
            return this;
        }
    }

    private class SearchTextFieldListener
    implements DocumentListener {
        private SearchTextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            HelpBrowser.this.search();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            HelpBrowser.this.search();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            HelpBrowser.this.search();
        }
    }

    private class HeplpSearchInit
    extends Thread {
        private HeplpSearchInit() {
            super("JPhotoTagger: Init Help Search");
        }

        @Override
        public void run() {
            final int index = HelpBrowser.this.tabbedPaneContents.indexOfComponent(HelpBrowser.this.panelSearch);
            HelpBrowser.this.tabbedPaneContents.setEnabledAt(index, false);
            HelpBrowser.this.helpSearch.startIndexing();
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    HelpBrowser.this.textFieldSearch.getDocument().addDocumentListener(new SearchTextFieldListener());
                    HelpBrowser.this.tabbedPaneContents.setEnabledAt(index, true);
                }
            });
        }
    }

    private final class GoToPreviousUrlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private GoToPreviousUrlAction() {
            super(Bundle.getString(HelpBrowser.class, "HelpBrowser.GoToPreviousUrlAction", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HelpBrowser.this.canGoToPreviousUrl()) {
                HelpBrowser.this.currentHistoryIndex--;
                URL url = (URL)HelpBrowser.this.urlHistory.get(HelpBrowser.this.currentHistoryIndex);
                HelpBrowser.this.setPage(url);
                URL previousUrl = (URL)HelpBrowser.this.urlHistory.get(HelpBrowser.this.currentHistoryIndex);
                String jPhotoTaggerPreviousUrl = HelpBrowser.this.toPageUrl(previousUrl);
                HelpBrowser.this.setSelectionPath(jPhotoTaggerPreviousUrl);
                HelpBrowser.this.setGotActionsEnabled();
            }
        }
    }

    private final class GoToNextUrlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private GoToNextUrlAction() {
            super(Bundle.getString(HelpBrowser.class, "HelpBrowser.GoToNextUrlAction", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HelpBrowser.this.canGoToNextUrl()) {
                HelpBrowser.this.currentHistoryIndex++;
                URL url = (URL)HelpBrowser.this.urlHistory.get(HelpBrowser.this.currentHistoryIndex);
                HelpBrowser.this.setPage(url);
                URL nextUrl = (URL)HelpBrowser.this.urlHistory.get(HelpBrowser.this.currentHistoryIndex);
                String jPhotoTaggerNextUrl = HelpBrowser.this.toPageUrl(nextUrl);
                HelpBrowser.this.setSelectionPath(jPhotoTaggerNextUrl);
                HelpBrowser.this.setGotActionsEnabled();
            }
        }
    }
}

