/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;

public final class TransferableObject
implements Transferable {
    private final Object data;
    private final DataFlavor[] dataFlavors;

    public TransferableObject(Object data, DataFlavor ... dataFlavors) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        if (dataFlavors == null) {
            throw new NullPointerException("dataFlavors == null");
        }
        this.data = data;
        this.dataFlavors = new DataFlavor[dataFlavors.length + 1];
        System.arraycopy(dataFlavors, 0, this.dataFlavors, 0, dataFlavors.length);
        this.dataFlavors[dataFlavors.length] = new DataFlavor(data.getClass(), null);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return Arrays.copyOf(this.dataFlavors, this.dataFlavors.length);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == null) {
            throw new NullPointerException("flavor == null");
        }
        for (DataFlavor dataFlavor : this.dataFlavors) {
            if (!flavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        return this.data;
    }
}

