/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jphototagger.lib.datatransfer.TransferUtil;

public final class TransferableFileCollection
implements Transferable {
    private static final DataFlavor FILE_LIST_FLAVOR = DataFlavor.javaFileListFlavor;
    private static final DataFlavor URI_LIST_FLAVOR = TransferUtil.getUriListFlavor();
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{FILE_LIST_FLAVOR, URI_LIST_FLAVOR};
    private static final String FILE_PROTOCOL = "file://";
    private static final String TOKEN_DELIMITER = "\r\n";
    private final Collection<File> files;
    private String fileUris;

    public TransferableFileCollection(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        this.files = new ArrayList<File>(files);
        this.createUriList();
    }

    private void createUriList() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.files) {
            sb.append(FILE_PROTOCOL).append(file.getAbsolutePath()).append(TOKEN_DELIMITER);
        }
        this.fileUris = sb.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == null) {
            throw new NullPointerException("flavor == null");
        }
        return flavor.equals(FILE_LIST_FLAVOR) || flavor.equals(URI_LIST_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor == null) {
            throw new NullPointerException("flavor == null");
        }
        if (flavor.equals(FILE_LIST_FLAVOR)) {
            return new ArrayList<File>(this.files);
        }
        if (flavor.equals(URI_LIST_FLAVOR)) {
            return this.fileUris;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

