/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class TransferUtil {
    private static final String MIME_TYPE_URI_LIST = "text/uri-list;class=java.lang.String";
    private static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    private static final DataFlavor FILE_LIST_FLAVOR = DataFlavor.javaFileListFlavor;
    private static DataFlavor URI_LIST_FLAVOR;

    public static Transferable getSelectedItemStringsTransferable(JList<Object> objects, String delimiter) {
        if (objects == null) {
            throw new NullPointerException("list == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        List<Object> values = objects.getSelectedValuesList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            Object val = values.get(i);
            sb.append(val == null ? "" : val.toString());
            sb.append(i != values.size() - 1 ? delimiter : "");
        }
        return new StringSelection(sb.toString());
    }

    public static Transferable getIntegerListTransferable(List<Integer> integers, String delimiter) {
        if (integers == null) {
            throw new NullPointerException("list == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        StringBuilder sb = new StringBuilder();
        int size = integers.size();
        for (int i = 0; i < size; ++i) {
            Integer integer = integers.get(i);
            sb.append(integer.toString());
            sb.append(i < size - 1 ? delimiter : "");
        }
        return new StringSelection(sb.toString());
    }

    public static Transferable getStringListTransferable(List<String> strings, String delimiter) {
        if (strings == null) {
            throw new NullPointerException("list == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        StringBuilder sb = new StringBuilder();
        int size = strings.size();
        for (int i = 0; i < size; ++i) {
            String string = strings.get(i);
            sb.append(string);
            sb.append(i < size - 1 ? delimiter : "");
        }
        return new StringSelection(sb.toString());
    }

    public static DataFlavor getUriListFlavor() {
        return URI_LIST_FLAVOR;
    }

    public static List<File> getFilesFromUriList(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            String data = (String)transferable.getTransferData(URI_LIST_FLAVOR);
            StringTokenizer st = new StringTokenizer(data, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!token.startsWith("file:")) continue;
                files.add(new File(new URI(token)));
            }
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return files;
    }

    public static List<File> getFilesFromTokenString(Transferable transferable, FilenameDelimiter delimiter) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            Object o = transferable.getTransferData(STRING_FLAVOR);
            if (o instanceof String) {
                String data = (String)o;
                StringTokenizer st = new StringTokenizer(data, delimiter.toString());
                while (st.hasMoreTokens()) {
                    files.add(new File(st.nextToken().trim()));
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return files;
    }

    public static List<File> getFilesFromJavaFileList(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        ArrayList<File> list = new ArrayList<File>();
        try {
            List files = (List)transferable.getTransferData(FILE_LIST_FLAVOR);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                list.add((File)it.next());
            }
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return list;
    }

    public static List<File> getFiles(Transferable transferable, FilenameDelimiter delimiter) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        if (TransferUtil.isDataFlavorSupported(flavors, FILE_LIST_FLAVOR)) {
            return TransferUtil.getFilesFromJavaFileList(transferable);
        }
        if (TransferUtil.isDataFlavorSupported(flavors, URI_LIST_FLAVOR)) {
            return TransferUtil.getFilesFromUriList(transferable);
        }
        if (TransferUtil.isDataFlavorSupported(flavors, STRING_FLAVOR)) {
            return TransferUtil.getFilesFromTokenString(transferable, delimiter);
        }
        return files;
    }

    public static boolean maybeContainFileData(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        return TransferUtil.containsFiles(transferable);
    }

    private static boolean containsFiles(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        try {
            if (TransferUtil.isDataFlavorSupported(flavors, FILE_LIST_FLAVOR)) {
                return ((List)transferable.getTransferData(FILE_LIST_FLAVOR)).size() > 0;
            }
            if (TransferUtil.isDataFlavorSupported(flavors, URI_LIST_FLAVOR)) {
                return ((String)transferable.getTransferData(URI_LIST_FLAVOR)).startsWith("file:");
            }
            if (TransferUtil.isDataFlavorSupported(flavors, STRING_FLAVOR)) {
                return new File((String)transferable.getTransferData(STRING_FLAVOR)).exists();
            }
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return false;
    }

    public static boolean systemClipboardMaybeContainFiles() {
        try {
            return TransferUtil.maybeContainFileData(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(TransferUtil.class));
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, "", t);
            return false;
        }
    }

    public static boolean isDataFlavorSupported(DataFlavor[] flavors, DataFlavor flavor) {
        if (flavors == null) {
            throw new NullPointerException("flavors == null");
        }
        if (flavor == null) {
            throw new NullPointerException("flavor == null");
        }
        for (DataFlavor f : flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isADataFlavorSupported(Transferable transferable, DataFlavor ... flavors) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        if (flavors == null) {
            throw new NullPointerException("flavors == null");
        }
        for (DataFlavor flavor : flavors) {
            if (!transferable.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCopy(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        if (!support.isDrop()) {
            throw new IllegalStateException("No drop!");
        }
        return (support.getSourceDropActions() & 1) == 1;
    }

    public static boolean isMove(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        if (!support.isDrop()) {
            throw new IllegalStateException("No drop!");
        }
        return (support.getSourceDropActions() & 2) == 2;
    }

    public static boolean isLink(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        if (!support.isDrop()) {
            throw new IllegalStateException("No drop!");
        }
        return (support.getSourceDropActions() & 0x40000000) == 0x40000000;
    }

    public static int getListDropIndex(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        boolean isList = support.getComponent() instanceof JList;
        if (!isList) {
            throw new IllegalArgumentException("Component is not a JList: " + support.getComponent());
        }
        if (!support.isDrop()) {
            return -1;
        }
        JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
        return dl.getIndex();
    }

    public static DefaultMutableTreeNode getTreeDropNode(TransferHandler.TransferSupport support) {
        Object o;
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        boolean isTree = support.getComponent() instanceof JTree;
        if (!isTree) {
            throw new IllegalArgumentException("Component is not a JTree: " + support.getComponent());
        }
        if (support.isDrop()) {
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            Object dropObject = dropLocation.getPath().getLastPathComponent();
            return dropObject instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)dropObject : null;
        }
        JTree tree = (JTree)support.getComponent();
        TreePath selPath = tree.getSelectionPath();
        if (selPath != null && (o = selPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)o;
        }
        return null;
    }

    private TransferUtil() {
    }

    static {
        try {
            URI_LIST_FLAVOR = new DataFlavor(MIME_TYPE_URI_LIST);
        }
        catch (Throwable t) {
            Logger.getLogger(TransferUtil.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public static enum FilenameDelimiter {
        EMPTY(""),
        NEWLINE("\n");

        private final String delimiter;

        private FilenameDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public String toString() {
            return this.delimiter;
        }
    }
}

