/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.concurrent;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.jphototagger.api.concurrent.Cancelable;

public final class SerialExecutor
implements Executor {
    private final Queue<Exec> runnables = new ArrayDeque<Exec>();
    private final Executor executor;
    private Exec active;

    public SerialExecutor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor == null");
        }
        this.executor = executor;
    }

    public synchronized void cancel() {
        this.runnables.clear();
        this.cancel(this.active);
    }

    private synchronized void cancel(Exec active) {
        if (active == null) {
            return;
        }
        if (active.r instanceof Cancelable) {
            ((Cancelable)active.r).cancel();
        } else if (active.r instanceof Thread) {
            ((Thread)active.r).interrupt();
        }
    }

    public synchronized int getCount() {
        int activeCount = this.active == null ? 0 : 1;
        return activeCount + this.runnables.size();
    }

    @Override
    public synchronized void execute(Runnable r) {
        this.runnables.offer(new Exec(r));
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    private synchronized void scheduleNext() {
        this.active = this.runnables.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
    }

    private class Exec
    implements Runnable {
        final Runnable r;

        Exec(Runnable r) {
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.r.run();
            }
            finally {
                SerialExecutor.this.scheduleNext();
            }
        }
    }
}

