/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.concurrent;

import java.util.HashSet;
import java.util.Set;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.progress.ProgressListener;
import org.openide.util.Lookup;

public abstract class HelperThread
extends Thread
implements Cancelable {
    private final Set<ProgressListener> progressListeners = new HashSet<ProgressListener>();
    private volatile Object info;
    private volatile int value;
    private volatile int minimum;
    private volatile int maximum;
    private ProgressHandle progressHandle;

    public HelperThread() {
    }

    public HelperThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            this.progressListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            this.progressListeners.remove(listener);
        }
    }

    public synchronized void setInfo(String info) {
        this.info = info;
    }

    protected void progressStarted(int minimum, int value, int maximum, Object info) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.info = info;
        ProgressEvent evt = this.createProgressEvent();
        this.notifyProgressStarted(evt);
        this.progressHandle = ((ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class)).createProgressHandle((Cancelable)this);
        this.progressHandle.progressStarted(evt);
    }

    protected void progressPerformed(int value, Object info) {
        this.value = value;
        this.info = info;
        ProgressEvent evt = this.createProgressEvent();
        this.notifyProgressPerformed(evt);
        this.progressHandle.progressPerformed(evt);
    }

    protected void progressEnded(Object info) {
        ProgressEvent evt = this.createProgressEvent();
        this.notifyProgressEnded(evt);
        this.progressHandle.progressEnded();
    }

    private ProgressEvent createProgressEvent() {
        return new ProgressEvent.Builder().source((Object)this).minimum(this.minimum).maximum(this.maximum).value(this.value).info(this.info).stringPainted(this.isProgressBarStringPainted()).stringToPaint(this.getProgressBarString()).build();
    }

    private boolean isProgressBarStringPainted() {
        return this.info != null;
    }

    private String getProgressBarString() {
        return this.info == null ? null : this.info.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProgressStarted(ProgressEvent evt) {
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            for (ProgressListener listener : this.progressListeners) {
                listener.progressStarted(evt);
                if (!evt.isCancel()) continue;
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProgressPerformed(ProgressEvent evt) {
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            for (ProgressListener listener : this.progressListeners) {
                listener.progressPerformed(evt);
                if (!evt.isCancel()) continue;
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProgressEnded(ProgressEvent evt) {
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            for (ProgressListener listener : this.progressListeners) {
                listener.progressEnded(evt);
            }
        }
    }
}

