/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.beansbinding;

import java.awt.Frame;
import java.io.Serializable;
import javax.swing.JOptionPane;
import org.jdesktop.beansbinding.Validator;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;

public final class MaxLengthValidator
extends Validator<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxLength;

    public MaxLengthValidator(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length < 0:" + maxLength);
        }
        this.maxLength = maxLength;
    }

    @Override
    public Validator.Result validate(String string) {
        if (string.length() > this.maxLength) {
            this.errorMessage();
        }
        return null;
    }

    private void errorMessage() {
        Frame parentFrame = ComponentUtil.findFrameWithIcon();
        String message = Bundle.getString(MaxLengthValidator.class, "MaxLengthValidator.Error", this.maxLength);
        String title = Bundle.getString(MaxLengthValidator.class, "MaxLengthValidator.Error.Title", new Object[0]);
        int messageType = 0;
        JOptionPane.showMessageDialog(parentFrame, message, title, messageType);
    }
}

