/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.collections.PositionProvider;

public final class LayerUtil {
    public static void logWarningIfNotUniquePositions(Collection<? extends PositionProvider> positionProviders) {
        if (positionProviders == null) {
            throw new NullPointerException("positionProviders == null");
        }
        Logger logger = Logger.getLogger(LayerUtil.class.getName());
        HashMap<Integer, ArrayList<PositionProvider>> providersOfPosition = new HashMap<Integer, ArrayList<PositionProvider>>();
        for (PositionProvider positionProvider : positionProviders) {
            int positionOfProvider = positionProvider.getPosition();
            ArrayList<PositionProvider> pop = (ArrayList<PositionProvider>)providersOfPosition.get(positionOfProvider);
            if (pop == null) {
                pop = new ArrayList<PositionProvider>();
                providersOfPosition.put(positionOfProvider, pop);
            }
            pop.add(positionProvider);
            if (pop.size() <= 1) continue;
            logger.log(Level.WARNING, "More than 1 Position Providers claims Position {0}: {1}", new Object[]{positionOfProvider, pop});
        }
    }

    private LayerUtil() {
    }
}

