/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.tasks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.event.UpdateMetadataCheckEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.concurrent.SerialExecutor;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.misc.SaveToOrUpdateFilesInRepositoryImpl;
import org.jphototagger.program.settings.SettingsDialog;
import org.jphototagger.program.tasks.InsertImageFilesIntoRepositoryScheduledTask;
import org.openide.util.Lookup;

public final class ScheduledTasks
implements ActionListener {
    private static final int DEFAULT_MINUTES_TO_START_SCHEDULED_TASKS = 5;
    private static final Map<ButtonState, Icon> ICON_OF_BUTTON_STATE = new EnumMap<ButtonState, Icon>(ButtonState.class);
    private static final Map<ButtonState, String> TOOLTIP_TEXT_OF_BUTTON_STATE = new EnumMap<ButtonState, String>(ButtonState.class);
    public static final ScheduledTasks INSTANCE = new ScheduledTasks();
    private final SerialExecutor executor = new SerialExecutor(Executors.newCachedThreadPool());
    private final JButton button = SettingsDialog.INSTANCE.getButtonScheduledTasks();
    private final long MINUTES_WAIT_BEFORE_PERFORM = ScheduledTasks.getMinutesToStartScheduledTasks();
    private volatile boolean isRunning;
    private volatile boolean runnedManual;

    private ScheduledTasks() {
        ScheduledTasks.init();
        this.listen();
    }

    private static void init() {
        TOOLTIP_TEXT_OF_BUTTON_STATE.put(ButtonState.START, Bundle.getString(ScheduledTasks.class, "ScheduledTasks.TooltipText.Start", new Object[0]));
        TOOLTIP_TEXT_OF_BUTTON_STATE.put(ButtonState.CANCEL, Bundle.getString(ScheduledTasks.class, "ScheduledTasks.TooltipText.Cancel", new Object[0]));
        ICON_OF_BUTTON_STATE.put(ButtonState.START, AppLookAndFeel.ICON_START);
        ICON_OF_BUTTON_STATE.put(ButtonState.CANCEL, AppLookAndFeel.ICON_CANCEL);
    }

    private void listen() {
        this.button.addActionListener(this);
        AnnotationProcessor.process(this);
    }

    public static int getMinutesToStartScheduledTasks() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        int minutes = prefs.getInt("UserSettings.MinutesToStartScheduledTasks");
        return minutes > 0 ? minutes : 5;
    }

    public synchronized void run() {
        if (this.isRunning || this.runnedManual || this.MINUTES_WAIT_BEFORE_PERFORM <= 0L) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.MINUTES.sleep(ScheduledTasks.this.MINUTES_WAIT_BEFORE_PERFORM);
                    if (!ScheduledTasks.this.runnedManual) {
                        ScheduledTasks.this.setStart();
                        ScheduledTasks.this.startUpdate();
                    }
                }
                catch (Throwable t) {
                    Logger.getLogger(ScheduledTasks.class.getName()).log(Level.SEVERE, null, this);
                }
            }
        }, "JPhotoTagger: Scheduled tasks");
        thread.start();
    }

    public int getCount() {
        return this.executor.getCount();
    }

    public void cancelCurrentTasks() {
        this.executor.cancel();
        this.setButtonState(ButtonState.START);
        this.isRunning = false;
    }

    private void startUpdate() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SaveToOrUpdateFilesInRepositoryImpl inserter = InsertImageFilesIntoRepositoryScheduledTask.getThread();
                if (inserter != null) {
                    ScheduledTasks.this.executor.execute(inserter);
                }
            }
        }, "JPhotoTagger: Inserting image files into repository").start();
    }

    @EventSubscriber(eventClass=UpdateMetadataCheckEvent.class)
    public void checkForUpdate(UpdateMetadataCheckEvent evt) {
        if (evt.getType().equals((Object)UpdateMetadataCheckEvent.Type.CHECK_FINISHED)) {
            this.setButtonState(ButtonState.START);
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        JButton jButton = this.button;
        synchronized (jButton) {
            if (this.isRunning) {
                this.cancelCurrentTasks();
            } else {
                this.runnedManual = true;
                this.setStart();
                this.startUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStart() {
        JButton jButton = this.button;
        synchronized (jButton) {
            this.isRunning = true;
            this.setButtonState(ButtonState.CANCEL);
        }
    }

    private void setButtonState(final ButtonState state) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ScheduledTasks.this.button.setIcon((Icon)ICON_OF_BUTTON_STATE.get((Object)state));
                ScheduledTasks.this.button.setToolTipText((String)TOOLTIP_TEXT_OF_BUTTON_STATE.get((Object)state));
            }
        });
    }

    private static enum ButtonState {
        START,
        CANCEL;

    }
}

