/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.repository.AutoscanDirectoriesRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ProgressBarUpdater;
import org.jphototagger.program.misc.SaveToOrUpdateFilesInRepositoryImpl;
import org.openide.util.Lookup;

public final class InsertImageFilesIntoRepositoryScheduledTask {
    private static final List<String> SYSTEM_DIRECTORIES_SUBSTRINGS = new ArrayList<String>();

    private InsertImageFilesIntoRepositoryScheduledTask() {
    }

    static SaveToOrUpdateFilesInRepositoryImpl getThread() {
        List<File> directories = InsertImageFilesIntoRepositoryScheduledTask.getDirectories();
        ArrayList<File> imageFiles = new ArrayList<File>(directories.size());
        if (!directories.isEmpty()) {
            for (File directory : directories) {
                if (InsertImageFilesIntoRepositoryScheduledTask.isSystemDirectory(directory.getAbsolutePath())) continue;
                imageFiles.addAll(InsertImageFilesIntoRepositoryScheduledTask.getImageFilesOfDirectory(directory));
            }
        }
        SaveToOrUpdateFilesInRepositoryImpl inserter = new SaveToOrUpdateFilesInRepositoryImpl(imageFiles, SaveOrUpdate.OUT_OF_DATE);
        String pBarString = Bundle.getString(InsertImageFilesIntoRepositoryScheduledTask.class, "InsertImageFilesIntoRepositoryScheduledTask.ProgressBar.String", new Object[0]);
        inserter.addProgressListener(new ProgressBarUpdater(inserter, pBarString));
        return inserter;
    }

    private static List<File> getImageFilesOfDirectory(File directory) {
        return FileFilterUtil.getImageFilesOfDirectory(directory);
    }

    private static List<File> getDirectories() {
        AutoscanDirectoriesRepository repo = Lookup.getDefault().lookup(AutoscanDirectoriesRepository.class);
        List<File> directories = repo.findAllAutoscanDirectories();
        InsertImageFilesIntoRepositoryScheduledTask.addSubdirectories(directories);
        Collections.sort(directories);
        Collections.reverse(directories);
        return directories;
    }

    private static void addSubdirectories(List<File> directories) {
        ArrayList<File> subdirectories = new ArrayList<File>();
        if (InsertImageFilesIntoRepositoryScheduledTask.isAutoscanIncludeSubdirectories()) {
            for (File directory : directories) {
                subdirectories.addAll(InsertImageFilesIntoRepositoryScheduledTask.getAllSubdirectories(directory));
            }
            directories.addAll(subdirectories);
        }
    }

    private static boolean isAutoscanIncludeSubdirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAutoscanIncludeSubdirectories") ? prefs.getBoolean("UserSettings.IsAutoscanIncludeSubdirectories") : true;
    }

    private static List<File> getAllSubdirectories(File directory) {
        return FileUtil.getSubDirectoriesRecursive(directory, null, InsertImageFilesIntoRepositoryScheduledTask.getDirFilterOptionShowHiddenFiles());
    }

    private static DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return InsertImageFilesIntoRepositoryScheduledTask.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private static boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private static boolean isSystemDirectory(String directoryName) {
        for (String substring : SYSTEM_DIRECTORIES_SUBSTRINGS) {
            if (!directoryName.contains(substring)) continue;
            return true;
        }
        return false;
    }

    static {
        SYSTEM_DIRECTORIES_SUBSTRINGS.add("System Volume Information");
        SYSTEM_DIRECTORIES_SUBSTRINGS.add("RECYCLER");
    }
}

