/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.tasks;

import org.jphototagger.api.concurrent.Cancelable;

final class AutomaticTask {
    static final AutomaticTask INSTANCE = new AutomaticTask();
    private Runnable runnable;

    public synchronized void setTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable == null");
        }
        this.cancelCurrentTask();
        this.runnable = runnable;
        this.startTask(runnable);
    }

    public void cancelCurrentTask() {
        if (this.runnable != null) {
            this.cancel(this.runnable);
        }
    }

    private synchronized void cancel(Runnable r) {
        if (r == null) {
            return;
        }
        if (r instanceof Cancelable) {
            ((Cancelable)((Object)r)).cancel();
        } else if (r instanceof Thread) {
            ((Thread)r).interrupt();
        }
    }

    private void startTask(final Runnable runnable) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        }, this.getName(runnable));
        t.start();
    }

    private String getName(Runnable runnable) {
        if (runnable instanceof Thread) {
            return ((Thread)runnable).getName();
        }
        return "JPhotoTagger: Automatic task @ " + runnable.getClass().getSimpleName();
    }

    private AutomaticTask() {
    }
}

